/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import ca.beq.util.win32.registry.RegistryKey;
import ca.beq.util.win32.registry.RegistryValue;
import ca.beq.util.win32.registry.RootKey;
import com.samskivert.swing.util.SwingUtil;
import com.samskivert.text.MessageUtil;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.AbortPanel;
import com.threerings.getdown.launcher.GetdownApp;
import com.threerings.getdown.launcher.ImageLoader;
import com.threerings.getdown.launcher.MultipleGetdownRunning;
import com.threerings.getdown.launcher.ProxyPanel;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.launcher.StatusPanel;
import com.threerings.getdown.net.Downloader;
import com.threerings.getdown.net.HTTPDownloader;
import com.threerings.getdown.tools.Patcher;
import com.threerings.getdown.util.ConfigUtil;
import com.threerings.getdown.util.ConnectionUtil;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.LaunchUtil;
import com.threerings.getdown.util.ProgressAggregator;
import com.threerings.getdown.util.ProgressObserver;
import com.threerings.getdown.util.VersionUtil;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Image;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.image.BufferedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.security.cert.Certificate;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import java.util.Timer;
import java.util.TimerTask;
import javax.imageio.ImageIO;
import javax.swing.AbstractAction;
import javax.swing.ImageIcon;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JLayeredPane;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Getdown
extends Thread
implements Application.StatusDisplay,
ImageLoader {
    protected ProgressObserver _progobs = new ProgressObserver(){

        public void progress(int percent) {
            Getdown.this.setStatusAsync(null, Getdown.this.stepToGlobalPercent(percent), -1L, false);
        }
    };
    protected Application _app;
    protected Application.UpdateInterface _ifc = new Application.UpdateInterface();
    protected ResourceBundle _msgs;
    protected Container _container;
    protected JLayeredPane _layers;
    protected StatusPanel _status;
    protected JButton _patchNotes;
    protected JButton _playAgain;
    protected AbortPanel _abort;
    protected RotatingBackgrounds _background;
    protected boolean _dead;
    protected boolean _silent;
    protected boolean _install;
    protected boolean _launchInSilent;
    protected long _startup;
    protected boolean _enableTracking = true;
    protected int _reportedProgress = 0;
    protected int _delay;
    protected int _stepMaxPercent;
    protected int _stepMinPercent;
    protected int _lastGlobalPercent;
    protected int _uiDisplayPercent;
    protected static final int MAX_LOOPS = 5;
    protected static final long MIN_EXIST_TIME = 5000L;
    protected static final long FALLBACK_CHECK_TIME = 1000L;
    protected static final long PLAY_AGAIN_TIME = 3000L;
    protected static final String PROXY_REGISTRY = "Software\\Microsoft\\Windows\\CurrentVersion\\Internet Settings";
    protected static List<Resource> toBeInstalledResouces;
    protected static boolean readyToInstall;

    public static void main(String[] args) {
        GetdownApp.main(args);
    }

    public Getdown(File appDir, String appId) {
        this(appDir, appId, null, null, null);
    }

    public Getdown(File appDir, String appId, List<Certificate> signers, String[] jvmargs, String[] appargs) {
        super("Getdown");
        try {
            this._silent = SysProps.silent();
            this._install = SysProps.install();
            if (this._silent) {
                this._launchInSilent = SysProps.launchInSilent();
            }
            this._delay = SysProps.startDelay();
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
        try {
            this._msgs = ResourceBundle.getBundle("com.threerings.getdown.messages");
        }
        catch (Exception e) {
            String dir = appDir.toString();
            if (dir.equals(".")) {
                dir = System.getProperty("user.dir");
            }
            String errmsg = "The directory in which this application is installed:\n" + dir + "\nis invalid (" + e.getMessage() + "). If the full path to the app directory contains the '!' character, this will trigger this error.";
            this.fail(errmsg);
        }
        this._app = new Application(appDir, appId, signers, jvmargs, appargs);
        this._startup = System.currentTimeMillis();
    }

    public void preInit() {
        try {
            this._ifc = this._app.init(true);
            this.createInterfaceAsync(true);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Failed to preinit: " + e), new Object[0]);
            this.createInterfaceAsync(true);
        }
    }

    @Override
    public void run() {
        if (this._msgs == null) {
            return;
        }
        File instdir = this._app.getLocalPath("");
        if (!instdir.canWrite()) {
            String path = instdir.getPath();
            if (path.equals(".")) {
                path = System.getProperty("user.dir");
            }
            this.fail(MessageUtil.tcompose((String)"m.readonly_error", (String[])new String[]{path}));
            return;
        }
        try {
            this._dead = false;
            if (this.detectProxy() || this._app.allowOffline()) {
                this.getdown();
            } else if (this._silent) {
                Log.log.warning((Object)"Need a proxy, but we don't want to bother anyone.  Exiting.", new Object[0]);
            } else {
                this._container = this.createContainer();
                this._container.add((Component)new ProxyPanel(this, this._msgs), "Center");
                this.showContainer();
                this._dead = true;
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)"run() failed.", new Object[]{e});
            String msg = e.getMessage();
            if (msg == null) {
                msg = MessageUtil.compose((String)"m.unknown_error", (String[])new String[]{this._ifc.installError});
            } else if (!msg.startsWith("m.")) {
                msg = e instanceof FileNotFoundException ? MessageUtil.compose((String)"m.missing_resource", (String[])new String[]{MessageUtil.taint((Object)msg), this._ifc.installError}) : MessageUtil.compose((String)"m.init_error", (String[])new String[]{MessageUtil.taint((Object)msg), this._ifc.installError});
            }
            this.fail(msg);
        }
    }

    public void configureProxy(String host, String port) {
        Log.log.info((Object)"User configured proxy", new Object[]{"host", host, "port", port});
        if (!StringUtil.isBlank((String)host)) {
            File pfile = this._app.getLocalPath("proxy.txt");
            try {
                PrintStream pout = new PrintStream(new FileOutputStream(pfile));
                pout.println("host = " + host);
                if (!StringUtil.isBlank((String)port)) {
                    pout.println("port = " + port);
                }
                pout.close();
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Error creating proxy file '" + pfile + "': " + ioe), new Object[0]);
            }
            this.setProxyProperties(host, port);
        }
        this.disposeContainer();
        this._container = null;
        new Thread(this).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean detectProxy() {
        File pfile;
        if (System.getProperty("http.proxyHost") != null) {
            return true;
        }
        if (RunAnywhere.isWindows()) {
            try {
                String host = null;
                String port = null;
                boolean enabled = false;
                RegistryKey.initialize();
                RegistryKey r = new RegistryKey(RootKey.HKEY_CURRENT_USER, PROXY_REGISTRY);
                Iterator iter = r.values();
                while (iter.hasNext()) {
                    RegistryValue value = (RegistryValue)iter.next();
                    if (value.getName().equals("ProxyEnable")) {
                        enabled = value.getStringValue().equals("1");
                    }
                    if (!value.getName().equals("ProxyServer")) continue;
                    String strval = value.getStringValue();
                    int cidx = strval.indexOf(":");
                    if (cidx != -1) {
                        port = strval.substring(cidx + 1);
                        strval = strval.substring(0, cidx);
                    }
                    host = strval;
                }
                if (enabled) {
                    this.setProxyProperties(host, port);
                    return true;
                }
                Log.log.info((Object)"Detected no proxy settings in the registry.", new Object[0]);
            }
            catch (Throwable t) {
                Log.log.info((Object)"Failed to find proxy settings in Windows registry", new Object[]{"error", t});
            }
        }
        if ((pfile = this._app.getLocalPath("proxy.txt")).exists()) {
            try {
                Map<String, Object> pconf = ConfigUtil.parseConfig(pfile, false);
                this.setProxyProperties((String)pconf.get("host"), (String)pconf.get("port"));
                return true;
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Failed to read '" + pfile + "': " + ioe), new Object[0]);
            }
        }
        Log.log.info((Object)"Checking whether we need to use a proxy...", new Object[0]);
        try {
            this._ifc = this._app.init(true);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        this.updateStatus("m.detecting_proxy");
        URL rurl = this._app.getConfigResource().getRemote();
        try {
            URLConnection conn = ConnectionUtil.open(rurl);
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)conn;
                try {
                    hcon.setRequestMethod("HEAD");
                    hcon.connect();
                    if (hcon.getResponseCode() != 200) {
                        Log.log.warning((Object)"Got a non-200 response but assuming we're OK because we got something...", new Object[]{"url", rurl, "rsp", hcon.getResponseCode()});
                    }
                }
                finally {
                    hcon.disconnect();
                }
            }
            Log.log.info((Object)"No proxy appears to be needed.", new Object[0]);
            try {
                pfile.createNewFile();
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Failed to create blank proxy file '" + pfile + "': " + ioe), new Object[0]);
            }
            return true;
        }
        catch (IOException ioe) {
            Log.log.info((Object)("Failed to HEAD " + rurl + ": " + ioe), new Object[0]);
            Log.log.info((Object)"We probably need a proxy, but auto-detection failed.", new Object[0]);
            return false;
        }
    }

    protected void setProxyProperties(String host, String port) {
        if (!StringUtil.isBlank((String)host)) {
            System.setProperty("http.proxyHost", host);
            System.setProperty("https.proxyHost", host);
            if (!StringUtil.isBlank((String)port)) {
                System.setProperty("http.proxyPort", port);
                System.setProperty("https.proxyPort", port);
            }
            Log.log.info((Object)"Using proxy", new Object[]{"host", host, "port", port});
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getdown() {
        Log.log.info((Object)"---------------- Proxy Info -----------------", new Object[0]);
        Log.log.info((Object)("-- Proxy Host: " + System.getProperty("http.proxyHost")), new Object[0]);
        Log.log.info((Object)("-- Proxy Port: " + System.getProperty("http.proxyPort")), new Object[0]);
        Log.log.info((Object)"---------------------------------------------", new Object[0]);
        try {
            try {
                this._ifc = this._app.init(true);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Failed to initialize: " + ioe), new Object[0]);
                this._app.attemptRecovery(this);
                this._ifc = this._app.init(true);
                this.createInterfaceAsync(true);
            }
            if (!this._app.lockForUpdates()) {
                throw new MultipleGetdownRunning();
            }
            File config = this._app.getLocalPath("getdown.txt");
            if (!config.setLastModified(System.currentTimeMillis())) {
                Log.log.warning((Object)"Unable to set modtime on config file, will be unable to check for another instance of getdown running while this one waits.", new Object[0]);
            }
            if (this._delay > 0) {
                this._app.releaseLock();
                long lastConfigModtime = config.lastModified();
                Log.log.info((Object)("Waiting " + this._delay + " minutes before beginning actual work."), new Object[0]);
                Thread.sleep(this._delay * 60 * 1000);
                if (lastConfigModtime < config.lastModified()) {
                    Log.log.warning((Object)"getdown.txt was modified while getdown was waiting.", new Object[0]);
                    throw new MultipleGetdownRunning();
                }
            }
            int[] alreadyValid = new int[1];
            HashSet<Resource> unpacked = new HashSet<Resource>();
            toBeInstalledResouces = new ArrayList<Resource>();
            readyToInstall = false;
            for (int ii = 0; ii < 5; ++ii) {
                if (!this._app.haveValidJavaVersion()) {
                    Log.log.info((Object)"Attempting to update Java VM...", new Object[0]);
                    this.setStep(Application.UpdateInterface.Step.UPDATE_JAVA);
                    this._enableTracking = true;
                    try {
                        this.updateJava();
                        continue;
                    }
                    finally {
                        this._enableTracking = false;
                    }
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_METADATA);
                this.setStatusAsync("m.validating", -1, -1L, false);
                if (this._app.verifyMetadata(this)) {
                    Log.log.info((Object)"Application requires update.", new Object[0]);
                    this.update();
                    continue;
                }
                this.setStep(Application.UpdateInterface.Step.VERIFY_RESOURCES);
                this.setStatusAsync("m.validating", -1, -1L, false);
                List<Resource> failures = this._app.verifyResources(this._progobs, alreadyValid, unpacked);
                this.addToBeInstalledResources(failures);
                if (failures == null) {
                    Log.log.info((Object)"Resources verified.", new Object[0]);
                    if (Boolean.getBoolean("check_unpacked")) {
                        File ufile = this._app.getLocalPath("unpacked.dat");
                        long version = -1L;
                        long aversion = this._app.getVersion();
                        if (!ufile.exists()) {
                            ufile.createNewFile();
                        } else {
                            version = VersionUtil.readVersion(ufile);
                        }
                        if (version < aversion) {
                            Log.log.info((Object)"Performing unpack.", new Object[]{"version", version, "aversion", aversion});
                            this.setStep(Application.UpdateInterface.Step.UNPACK);
                            this.updateStatus("m.validating");
                            this._app.unpackResources(this._progobs, unpacked);
                            try {
                                VersionUtil.writeVersion(ufile, aversion);
                            }
                            catch (IOException ioe) {
                                Log.log.warning((Object)"Failed to update unpacked version", new Object[]{ioe});
                            }
                        }
                    }
                    readyToInstall = true;
                    if (this._install) {
                        Getdown.install();
                    }
                    if (!this._silent || this._launchInSilent) {
                        if (Thread.interrupted()) {
                            throw new InterruptedException("m.applet_stopped");
                        }
                        this._app.lockForUpdates();
                        this.launch();
                    }
                    return;
                }
                try {
                    this._enableTracking = alreadyValid[0] == 0;
                    this.reportTrackingEvent("app_start", -1);
                    Log.log.info((Object)(failures.size() + " of " + this._app.getAllActiveResources().size() + " rsrcs require update (" + alreadyValid[0] + " assumed valid)."), new Object[0]);
                    this.setStep(Application.UpdateInterface.Step.REDOWNLOAD_RESOURCES);
                    this.download(failures);
                    this.reportTrackingEvent("app_complete", -1);
                    continue;
                }
                finally {
                    this._enableTracking = false;
                }
            }
            Log.log.warning((Object)"Pants! We couldn't get the job done.", new Object[0]);
            throw new IOException("m.unable_to_repair");
        }
        catch (Exception e) {
            Log.log.warning((Object)"getdown() failed.", new Object[]{e});
            String msg = e.getMessage();
            if (msg == null) {
                msg = MessageUtil.compose((String)"m.unknown_error", (String[])new String[]{this._ifc.installError});
            } else if (!msg.startsWith("m.")) {
                msg = e instanceof FileNotFoundException ? MessageUtil.compose((String)"m.missing_resource", (String[])new String[]{MessageUtil.taint((Object)msg), this._ifc.installError}) : MessageUtil.compose((String)"m.init_error", (String[])new String[]{MessageUtil.taint((Object)msg), this._ifc.installError});
            }
            this.fail(msg);
            this._app.releaseLock();
            return;
        }
    }

    private void addToBeInstalledResources(List<Resource> resources) {
        if (resources == null) {
            return;
        }
        for (Resource r : resources) {
            if (toBeInstalledResouces.contains(r)) continue;
            toBeInstalledResouces.add(r);
        }
    }

    @Override
    public void updateStatus(String message) {
        this.setStatusAsync(message, -1, -1L, true);
    }

    @Override
    public BufferedImage loadImage(String path) {
        if (StringUtil.isBlank((String)path)) {
            return null;
        }
        File imgpath = null;
        try {
            String localeStr = Locale.getDefault().getLanguage();
            imgpath = this._app.getLocalPath(path.replace(".", "_" + localeStr + "."));
            return ImageIO.read(imgpath);
        }
        catch (IOException localeStr) {
            try {
                imgpath = this._app.getLocalPath(path);
                return ImageIO.read(imgpath);
            }
            catch (IOException ioe2) {
                Log.log.warning((Object)"Failed to load image", new Object[]{"path", imgpath, "error", ioe2});
                return null;
            }
        }
    }

    protected void updateJava() throws IOException, InterruptedException {
        Resource vmjar = this._app.getJavaVMResource();
        if (vmjar == null) {
            throw new IOException("m.java_download_failed");
        }
        this.reportTrackingEvent("jvm_start", -1);
        this.updateStatus("m.downloading_java");
        ArrayList<Resource> list = new ArrayList<Resource>();
        list.add(vmjar);
        this.download(list);
        this.reportTrackingEvent("jvm_unpack", -1);
        this.updateStatus("m.unpacking_java");
        if (!vmjar.unpack()) {
            throw new IOException("m.java_unpack_failed");
        }
        vmjar.markAsValid();
        if (!RunAnywhere.isWindows()) {
            String vmbin = "java_vm" + File.separator + "bin" + File.separator + "java";
            String cmd = "chmod a+rx " + this._app.getLocalPath(vmbin);
            try {
                Log.log.info((Object)("Please smack a Java engineer. Running: " + cmd), new Object[0]);
                Runtime.getRuntime().exec(cmd);
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failed to mark VM binary as executable", new Object[]{"cmd", cmd, "error", e});
            }
        }
        String vmpath = LaunchUtil.getJVMPath(this._app.getLocalPath(""));
        try {
            Log.log.info((Object)("Regenerating classes.jsa for " + vmpath + "..."), new Object[0]);
            Runtime.getRuntime().exec(vmpath + " -Xshare:dump");
        }
        catch (Exception e) {
            Log.log.warning((Object)"Failed to regenerate .jsa dum file", new Object[]{"error", e});
        }
        this.reportTrackingEvent("jvm_complete", -1);
    }

    protected void update() throws IOException, InterruptedException {
        this._app.clearValidationMarkers();
        Resource patch = this._app.getPatchResource(null);
        if (patch != null) {
            ArrayList<Resource> list = new ArrayList<Resource>();
            list.add(patch);
            for (Application.AuxGroup aux : this._app.getAuxGroups()) {
                if (!this._app.isAuxGroupActive(aux.name) || (patch = this._app.getPatchResource(aux.name)) == null) continue;
                list.add(patch);
            }
            if (!StringUtil.isBlank((String)this._ifc.patchNotesUrl)) {
                this.createInterfaceAsync(false);
                EventQueue.invokeLater(new Runnable(){

                    public void run() {
                        Getdown.this._patchNotes.setVisible(true);
                    }
                });
            }
            this.setStep(Application.UpdateInterface.Step.DOWNLOAD);
            this.download(list);
            this.setStep(Application.UpdateInterface.Step.PATCH);
            this.updateStatus("m.patching");
            long[] sizes = new long[list.size()];
            Arrays.fill(sizes, 1L);
            ProgressAggregator pragg = new ProgressAggregator(this._progobs, sizes);
            int ii = 0;
            for (Resource prsrc : list) {
                ProgressObserver pobs = pragg.startElement(ii++);
                try {
                    Patcher patcher = new Patcher();
                    patcher.patch(prsrc.getLocal().getParentFile(), prsrc.getLocal(), pobs);
                }
                catch (Exception e) {
                    Log.log.warning((Object)"Failed to apply patch", new Object[]{"prsrc", prsrc, e});
                }
                if (prsrc.getLocal().delete()) continue;
                Log.log.warning((Object)("Failed to delete '" + prsrc + "'."), new Object[0]);
                prsrc.getLocal().deleteOnExit();
            }
        }
        this._app.updateMetadata();
        this._ifc = this._app.init(true);
    }

    protected void download(List<Resource> resources) throws IOException, InterruptedException {
        this.createInterfaceAsync(false);
        Downloader.Observer obs = new Downloader.Observer(){
            protected int _lastCheck = -1;

            public void resolvingDownloads() {
                Getdown.this.updateStatus("m.resolving");
            }

            public boolean downloadProgress(int percent, long remaining) {
                if (this._lastCheck == -1 || percent >= this._lastCheck + 10) {
                    if (Getdown.this._delay > 0) {
                        boolean locked = Getdown.this._app.lockForUpdates();
                        Getdown.this._app.releaseLock();
                        return locked;
                    }
                    this._lastCheck = percent;
                }
                if (Thread.currentThread().isInterrupted()) {
                    return false;
                }
                Getdown.this.setStatusAsync("m.downloading", Getdown.this.stepToGlobalPercent(percent), remaining, true);
                if (percent > 0) {
                    Getdown.this.reportTrackingEvent("progress", percent);
                }
                return true;
            }

            public void downloadFailed(Resource rsrc, Exception e) {
                Getdown.this.updateStatus(MessageUtil.tcompose((String)"m.failure", (String[])new String[]{e.getMessage()}));
                Log.log.warning((Object)"Download failed", new Object[]{"rsrc", rsrc, e});
            }
        };
        HTTPDownloader dl = new HTTPDownloader(resources, obs);
        if (!dl.download()) {
            if (Thread.interrupted()) {
                throw new InterruptedException("m.applet_stopped");
            }
            throw new MultipleGetdownRunning();
        }
    }

    public static void install() throws IOException, InterruptedException {
        if (readyToInstall) {
            Log.log.info((Object)"Installing downloaded resources:", new Object[0]);
            for (Resource resource : toBeInstalledResouces) {
                Log.log.info((Object)resource, new Object[0]);
                if (!FileUtil.renameTo(resource.getLocalNew(), resource.getLocal())) {
                    throw new IOException("Failed to rename(" + resource.getLocalNew() + ", " + resource.getLocal() + ")");
                }
                if (!Thread.interrupted()) continue;
                throw new InterruptedException("m.applet_stopped");
            }
            toBeInstalledResouces.clear();
            readyToInstall = false;
            Log.log.info((Object)"Install completed.", new Object[0]);
        } else {
            Log.log.info((Object)"Nothing to install.", new Object[0]);
        }
    }

    public static boolean isUpdateAvailable() {
        return readyToInstall && !toBeInstalledResouces.isEmpty();
    }

    protected void launch() {
        this.setStep(Application.UpdateInterface.Step.LAUNCH);
        this.setStatusAsync("m.launching", this.stepToGlobalPercent(100), -1L, false);
        try {
            if (this.invokeDirect()) {
                this.disposeContainer();
                this._app.releaseLock();
                this._app.invokeDirect(this.getApplet());
            } else {
                Process proc;
                if (this._app.hasOptimumJvmArgs()) {
                    proc = this._app.createProcess(true);
                    long fallback = System.currentTimeMillis() + 1000L;
                    boolean error = false;
                    while (fallback > System.currentTimeMillis()) {
                        try {
                            error = proc.exitValue() != 0;
                            break;
                        }
                        catch (IllegalThreadStateException e) {
                            Thread.yield();
                        }
                    }
                    if (error) {
                        Log.log.info((Object)"Failed to launch with optimum arguments; falling back.", new Object[0]);
                        proc = this._app.createProcess(false);
                    }
                } else {
                    proc = this._app.createProcess(false);
                }
                proc.getInputStream().close();
                proc.getOutputStream().close();
                final InputStream stderr = proc.getErrorStream();
                if (LaunchUtil.mustMonitorChildren()) {
                    this.disposeContainer();
                    this._container = null;
                    Getdown.copyStream(stderr, System.err);
                    Log.log.info((Object)("Process exited: " + proc.waitFor()), new Object[0]);
                } else {
                    Thread t = new Thread(){

                        public void run() {
                            Getdown.copyStream(stderr, System.err);
                        }
                    };
                    t.setDaemon(true);
                    t.start();
                }
            }
            long uptime = System.currentTimeMillis() - this._startup;
            if (this._container != null && uptime < 5000L) {
                try {
                    Thread.sleep(5000L - uptime);
                }
                catch (Exception t) {
                    // empty catch block
                }
            }
            this.setStatusAsync(null, 100, -1L, false);
            this.exit(0);
            if (this._playAgain != null && this._playAgain.isEnabled()) {
                Timer timer = new Timer("playAgain", true);
                timer.schedule(new TimerTask(){

                    public void run() {
                        Getdown.this.initPlayAgain();
                        Getdown.this._playAgain.setVisible(true);
                    }
                }, 3000L);
            }
        }
        catch (Exception e) {
            Log.log.warning((Object)"launch() failed.", new Object[]{e});
        }
    }

    protected void createInterfaceAsync(final boolean reinit) {
        if (this._silent || this._container != null && !reinit) {
            return;
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (Getdown.this._container == null || reinit) {
                    if (Getdown.this._container == null) {
                        Getdown.this._container = Getdown.this.createContainer();
                    } else {
                        Getdown.this._container.removeAll();
                    }
                    Getdown.this._layers = new JLayeredPane();
                    Getdown.this._container.add((Component)Getdown.this._layers, "Center");
                    Getdown.this._patchNotes = new JButton(new AbstractAction(Getdown.this._msgs.getString("m.patch_notes")){

                        public void actionPerformed(ActionEvent event) {
                            Getdown.this.showDocument(Getdown.this._ifc.patchNotesUrl);
                        }
                    });
                    Getdown.this._patchNotes.setFont(StatusPanel.FONT);
                    Getdown.this._layers.add(Getdown.this._patchNotes);
                    if (Getdown.this.getApplet() != null) {
                        Getdown.this._playAgain = new JButton();
                        Getdown.this._playAgain.setEnabled(false);
                        Getdown.this._playAgain.setCursor(Cursor.getPredefinedCursor(12));
                        Getdown.this._playAgain.setFont(StatusPanel.FONT);
                        Getdown.this._playAgain.addActionListener(new ActionListener(){

                            public void actionPerformed(ActionEvent event) {
                                Getdown.this._playAgain.setVisible(false);
                                Getdown.this._lastGlobalPercent = 0;
                                Getdown.this._stepMinPercent = 0;
                                EventQueue.invokeLater(new Runnable(){

                                    public void run() {
                                        Getdown.this.getdown();
                                    }
                                });
                            }
                        });
                        Getdown.this._layers.add(Getdown.this._playAgain);
                    }
                    Getdown.this._status = new StatusPanel(Getdown.this._msgs);
                    Getdown.this._layers.add(Getdown.this._status);
                    Getdown.this.initInterface();
                }
                Getdown.this.showContainer();
            }
        });
    }

    protected void initInterface() {
        RotatingBackgrounds newBackgrounds = this.getBackground();
        if (this._background == null || newBackgrounds.getNumImages() > 0) {
            this._background = newBackgrounds;
        }
        this._status.init(this._ifc, this._background, this.getProgressImage());
        Dimension size = this._status.getPreferredSize();
        this._status.setSize(size);
        this._layers.setPreferredSize(size);
        this._patchNotes.setBounds(this._ifc.patchNotes);
        this._patchNotes.setVisible(false);
        this.initPlayAgain();
        this._uiDisplayPercent = this._lastGlobalPercent;
        this._lastGlobalPercent = 0;
        this._stepMinPercent = 0;
    }

    protected void initPlayAgain() {
        if (this._playAgain != null) {
            boolean hasImage;
            BufferedImage image = this.loadImage(this._ifc.playAgainImage);
            boolean bl = hasImage = image != null;
            if (hasImage) {
                this._playAgain.setIcon(new ImageIcon(image));
                this._playAgain.setText("");
            } else {
                this._playAgain.setText(this._msgs.getString("m.play_again"));
                this._playAgain.setIcon(null);
            }
            this._playAgain.setBorderPainted(!hasImage);
            this._playAgain.setOpaque(!hasImage);
            this._playAgain.setContentAreaFilled(!hasImage);
            if (this._ifc.playAgain != null) {
                this._playAgain.setBounds(this._ifc.playAgain);
                this._playAgain.setEnabled(true);
            }
            this._playAgain.setVisible(false);
        }
    }

    protected RotatingBackgrounds getBackground() {
        if (this._ifc.rotatingBackgrounds != null) {
            if (this._ifc.backgroundImage != null) {
                Log.log.warning((Object)"ui.background_image and ui.rotating_background were both specified. The rotating images are being used.", new Object[0]);
            }
            return new RotatingBackgrounds(this._ifc.rotatingBackgrounds, this._ifc.errorBackground, this);
        }
        if (this._ifc.backgroundImage != null) {
            return new RotatingBackgrounds(this.loadImage(this._ifc.backgroundImage));
        }
        return new RotatingBackgrounds();
    }

    protected Image getProgressImage() {
        return this.loadImage(this._ifc.progressImage);
    }

    protected void handleWindowClose() {
        if (this._dead) {
            this.exit(0);
        } else {
            if (this._abort == null) {
                this._abort = new AbortPanel(this, this._msgs);
            }
            this._abort.pack();
            SwingUtil.centerWindow((Window)this._abort);
            this._abort.setVisible(true);
            this._abort.setState(0);
            this._abort.requestFocus();
        }
    }

    protected void fail(String message) {
        this._dead = true;
        this.setStatusAsync(message, this.stepToGlobalPercent(0), -1L, true);
    }

    protected void setStep(Application.UpdateInterface.Step step) {
        int finalPercent = -1;
        for (Integer perc : this._ifc.stepPercentages.get((Object)step)) {
            if (perc <= this._stepMaxPercent) continue;
            finalPercent = perc;
            break;
        }
        if (finalPercent == -1) {
            return;
        }
        this._stepMaxPercent = finalPercent;
        this._stepMinPercent = this._lastGlobalPercent;
    }

    protected int stepToGlobalPercent(int percent) {
        int adjustedMaxPercent = (this._stepMaxPercent - this._uiDisplayPercent) * 100 / (100 - this._uiDisplayPercent);
        this._lastGlobalPercent = Math.max(this._lastGlobalPercent, this._stepMinPercent + percent * (adjustedMaxPercent - this._stepMinPercent) / 100);
        return this._lastGlobalPercent;
    }

    protected void setStatusAsync(final String message, final int percent, final long remaining, boolean createUI) {
        if (this._status == null && createUI) {
            this.createInterfaceAsync(false);
        }
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                if (Getdown.this._status == null) {
                    if (message != null) {
                        Log.log.info((Object)("Dropping status '" + message + "'."), new Object[0]);
                    }
                    return;
                }
                if (message != null) {
                    Getdown.this._status.setStatus(message, Getdown.this._dead);
                }
                if (Getdown.this._dead) {
                    Getdown.this._status.setProgress(0, -1L);
                } else if (percent >= 0) {
                    Getdown.this._status.setProgress(percent, remaining);
                }
            }
        });
    }

    protected void reportTrackingEvent(String event, int progress) {
        if (!this._enableTracking) {
            return;
        }
        if (progress > 0) {
            do {
                URL url;
                if ((url = this._app.getTrackingProgressURL(++this._reportedProgress)) == null) continue;
                new ProgressReporter(url).start();
            } while (this._reportedProgress <= progress);
        } else {
            URL url = this._app.getTrackingURL(event);
            if (url != null) {
                new ProgressReporter(url).start();
            }
        }
    }

    protected abstract Container createContainer();

    protected abstract void showContainer();

    protected abstract void disposeContainer();

    protected boolean invokeDirect() {
        return SysProps.direct();
    }

    protected JApplet getApplet() {
        return null;
    }

    protected abstract void showDocument(String var1);

    protected abstract void exit(int var1);

    protected static void copyStream(InputStream in, PrintStream out) {
        try {
            String line;
            BufferedReader reader = new BufferedReader(new InputStreamReader(in));
            while ((line = reader.readLine()) != null) {
                out.print(line);
                out.flush();
            }
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failure copying", new Object[]{"in", in, "out", out, "error", ioe});
        }
    }

    protected class ProgressReporter
    extends Thread {
        protected URL _url;

        public ProgressReporter(URL url) {
            this.setDaemon(true);
            this._url = url;
        }

        public void run() {
            try {
                String val;
                HttpURLConnection ucon = ConnectionUtil.openHttp(this._url);
                if (Getdown.this._app.getTrackingCookieName() != null && Getdown.this._app.getTrackingCookieProperty() != null && (val = System.getProperty(Getdown.this._app.getTrackingCookieProperty())) != null) {
                    ucon.setRequestProperty("Cookie", Getdown.this._app.getTrackingCookieName() + "=" + val);
                }
                ucon.connect();
                try {
                    if (ucon.getResponseCode() != 200) {
                        Log.log.warning((Object)"Failed to report tracking event", new Object[]{"url", this._url, "rcode", ucon.getResponseCode()});
                    }
                }
                finally {
                    ucon.disconnect();
                }
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failed to report tracking event", new Object[]{"url", this._url, "error", ioe});
            }
        }
    }
}

