/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.swing.util.SwingUtil;
import com.samskivert.util.ArrayUtil;
import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.SysProps;
import com.threerings.getdown.launcher.Getdown;
import java.awt.Container;
import java.awt.Frame;
import java.awt.Window;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.swing.JFrame;

public class GetdownApp {
    public static void main(String[] argv) {
        String appId;
        int aidx = 0;
        List<String> args = Arrays.asList(argv);
        String adarg = SysProps.appDir();
        if (StringUtil.isBlank((String)adarg)) {
            if (args.isEmpty()) {
                System.err.println("Usage: java -jar getdown.jar app_dir [app_id] [app args]");
                System.exit(-1);
            }
            adarg = args.get(aidx++);
        }
        if (StringUtil.isBlank((String)(appId = SysProps.appId())) && aidx < args.size()) {
            appId = args.get(aidx++);
        }
        String[] appArgs = aidx >= args.size() ? null : args.subList(aidx, args.size()).toArray(ArrayUtil.EMPTY_STRING);
        File appDir = new File(adarg);
        if (!appDir.exists() || !appDir.isDirectory()) {
            Log.log.warning((Object)("Invalid app_dir '" + adarg + "'."), new Object[0]);
            System.exit(-1);
        }
        if (!SysProps.noLogRedir()) {
            File logFile = new File(appDir, "launcher.log");
            try {
                PrintStream logOut = new PrintStream(new BufferedOutputStream(new FileOutputStream(logFile)), true);
                System.setOut(logOut);
                System.setErr(logOut);
            }
            catch (IOException ioe) {
                Log.log.warning((Object)("Unable to redirect output to '" + logFile + "': " + ioe), new Object[0]);
            }
        }
        Log.log.info((Object)"------------------ VM Info ------------------", new Object[0]);
        Log.log.info((Object)("-- OS Name: " + System.getProperty("os.name")), new Object[0]);
        Log.log.info((Object)("-- OS Arch: " + System.getProperty("os.arch")), new Object[0]);
        Log.log.info((Object)("-- OS Vers: " + System.getProperty("os.version")), new Object[0]);
        Log.log.info((Object)("-- Java Vers: " + System.getProperty("java.version")), new Object[0]);
        Log.log.info((Object)("-- Java Home: " + System.getProperty("java.home")), new Object[0]);
        Log.log.info((Object)("-- User Name: " + System.getProperty("user.name")), new Object[0]);
        Log.log.info((Object)("-- User Home: " + System.getProperty("user.home")), new Object[0]);
        Log.log.info((Object)("-- Cur dir: " + System.getProperty("user.dir")), new Object[0]);
        Log.log.info((Object)"---------------------------------------------", new Object[0]);
        try {
            Getdown app = new Getdown(appDir, appId, null, null, appArgs){
                protected JFrame _frame;

                protected Container createContainer() {
                    String title;
                    String string = title = StringUtil.isBlank((String)this._ifc.name) ? "" : this._ifc.name;
                    if (this._frame == null) {
                        this._frame = new JFrame(title);
                        this._frame.addWindowListener(new WindowAdapter(){

                            public void windowClosing(WindowEvent evt) {
                                this.handleWindowClose();
                            }
                        });
                        this._frame.setUndecorated(this._ifc.hideDecorations);
                        this._frame.setResizable(false);
                    } else {
                        this._frame.setTitle(title);
                        this._frame.getContentPane().removeAll();
                    }
                    if (this._ifc.iconImages != null) {
                        ArrayList<BufferedImage> icons = new ArrayList<BufferedImage>();
                        for (String path : this._ifc.iconImages) {
                            BufferedImage img = this.loadImage(path);
                            if (img == null) {
                                Log.log.warning((Object)"Error loading icon image", new Object[]{"path", path});
                                continue;
                            }
                            icons.add(img);
                        }
                        if (icons.isEmpty()) {
                            Log.log.warning((Object)"Failed to load any icons", new Object[]{"iconImages", this._ifc.iconImages});
                        } else {
                            SwingUtil.setFrameIcons((Frame)this._frame, icons);
                        }
                    }
                    this._frame.setDefaultCloseOperation(0);
                    return this._frame.getContentPane();
                }

                protected void showContainer() {
                    if (this._frame != null) {
                        this._frame.pack();
                        SwingUtil.centerWindow((Window)this._frame);
                        this._frame.setVisible(true);
                    }
                }

                protected void disposeContainer() {
                    if (this._frame != null) {
                        this._frame.dispose();
                        this._frame = null;
                    }
                }

                protected void showDocument(String url) {
                    String osName;
                    String[] cmdarray = RunAnywhere.isWindows() ? ((osName = System.getProperty("os.name")).indexOf("9") != -1 || osName.indexOf("Me") != -1 ? new String[]{"command.com", "/c", "start", "\"" + url + "\""} : new String[]{"cmd.exe", "/c", "start", "\"\"", "\"" + url + "\""}) : (RunAnywhere.isMacOS() ? new String[]{"open", url} : new String[]{"firefox", url});
                    try {
                        Runtime.getRuntime().exec(cmdarray);
                    }
                    catch (Exception e) {
                        Log.log.warning((Object)"Failed to open browser.", new Object[]{"cmdarray", cmdarray, e});
                    }
                }

                protected void exit(int exitCode) {
                    if (this.invokeDirect()) {
                        this.disposeContainer();
                    } else {
                        System.exit(exitCode);
                    }
                }

                protected void fail(String message) {
                    if (this._frame != null && this._frame.isUndecorated()) {
                        this._frame.dispose();
                        this._frame.setUndecorated(false);
                        this.showContainer();
                    }
                    super.fail(message);
                }
            };
            app.start();
        }
        catch (Exception e) {
            Log.log.warning((Object)"main() failed.", new Object[]{e});
        }
    }
}

