/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.threerings.getdown.Log;
import com.threerings.getdown.launcher.Getdown;
import com.threerings.getdown.launcher.GetdownAppletConfig;
import com.threerings.getdown.launcher.ImageLoader;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import java.awt.Container;
import java.awt.Image;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintStream;
import java.net.InetAddress;
import java.net.MalformedURLException;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.URL;
import java.security.cert.Certificate;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.util.ArrayList;
import javax.swing.JApplet;
import javax.swing.JPanel;
import netscape.javascript.JSObject;

public class GetdownApplet
extends JApplet
implements ImageLoader {
    protected GetdownAppletConfig _config;
    protected Getdown _getdown;
    protected String _errmsg;
    protected JSObject _messageCallback;
    protected ServerSocket _serverSocket;
    protected DataOutputStream _connectOut;

    public synchronized void setMessageCallback(JSObject callback) {
        this._messageCallback = callback;
    }

    public synchronized boolean sendMessage(String message) {
        if (this._connectOut != null) {
            try {
                this._connectOut.writeUTF(message);
                return true;
            }
            catch (IOException e) {
                Log.log.warning((Object)"Error sending message to app.", new Object[]{"message", message, e});
            }
        }
        return false;
    }

    public void init() {
        this._config = new GetdownAppletConfig(this);
        try {
            try {
                this._config.init();
            }
            catch (Exception e) {
                this._errmsg = e.getMessage();
            }
            ArrayList<Certificate> signers = new ArrayList<Certificate>();
            Certificate cert = GetdownApplet.loadCertificate("resource.crt");
            if (cert != null) {
                signers.add(cert);
            } else {
                Log.log.warning((Object)"No resource certificate found, falling back to class signers", new Object[0]);
                for (Object signer : GetdownApplet.class.getSigners()) {
                    if (!(signer instanceof Certificate)) continue;
                    signers.add((Certificate)signer);
                }
            }
            this._getdown = new Getdown(this._config.appdir, null, signers, this._config.jvmargs, this._config.appargs){

                protected Container createContainer() {
                    GetdownApplet.this.getContentPane().removeAll();
                    return GetdownApplet.this.getContentPane();
                }

                protected RotatingBackgrounds getBackground() {
                    return GetdownApplet.this._config.getBackgroundImages(GetdownApplet.this);
                }

                protected void showContainer() {
                    ((JPanel)GetdownApplet.this.getContentPane()).revalidate();
                }

                protected void disposeContainer() {
                }

                protected boolean invokeDirect() {
                    return GetdownApplet.this._config.invokeDirect;
                }

                protected JApplet getApplet() {
                    return GetdownApplet.this;
                }

                protected void showDocument(String url) {
                    try {
                        GetdownApplet.this.getAppletContext().showDocument(new URL(url), "_blank");
                    }
                    catch (MalformedURLException e) {
                        Log.log.warning((Object)"Invalid document url.", new Object[]{"url", url, e});
                    }
                }

                protected void launch() {
                    if (GetdownApplet.this._config.allowConnect) {
                        try {
                            GetdownApplet.this.startConnectServer();
                        }
                        catch (IOException e) {
                            Log.log.warning((Object)"Failed to start connect server.", new Object[]{e});
                        }
                    }
                    super.launch();
                }

                protected void exit(int exitCode) {
                    this._status.stopThrob();
                    this._app.releaseLock();
                    GetdownApplet.this._config.redirect();
                }
            };
            this._config.config(this._getdown);
            this._getdown.preInit();
        }
        catch (Exception e) {
            if (this._errmsg == null) {
                this._errmsg = e.getMessage();
            }
            Log.log.warning((Object)"init() failed.", new Object[]{e});
        }
    }

    protected void startConnectServer() throws IOException {
        this._serverSocket = new ServerSocket(0, 0, InetAddress.getByName(null));
        String port = String.valueOf(this._serverSocket.getLocalPort());
        Log.log.info((Object)"Listening for connections from launched app.", new Object[]{"port", port});
        System.setProperty("app.com.threerings.getdown.connectPort", port);
        Thread thread = new Thread("ConnectServer"){

            public void run() {
                try {
                    while (true) {
                        this.acceptConnection();
                    }
                }
                catch (IOException e) {
                    block3: {
                        if (GetdownApplet.this._serverSocket.isClosed()) break block3;
                        Log.log.warning((Object)"Error accepting connection.", new Object[]{e});
                    }
                    return;
                }
            }

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             * Enabled aggressive block sorting
             * Enabled unnecessary exception pruning
             * Enabled aggressive exception aggregation
             */
            protected void acceptConnection() throws IOException {
                GetdownApplet getdownApplet;
                block11: {
                    Socket socket = GetdownApplet.this._serverSocket.accept();
                    Log.log.info((Object)"App connected.", new Object[]{"port", socket.getPort()});
                    DataInputStream connectIn = new DataInputStream(socket.getInputStream());
                    getdownApplet = GetdownApplet.this;
                    synchronized (getdownApplet) {
                        GetdownApplet.this._connectOut = new DataOutputStream(socket.getOutputStream());
                    }
                    try {
                        while (true) {
                            String message = connectIn.readUTF();
                            GetdownApplet getdownApplet2 = GetdownApplet.this;
                            synchronized (getdownApplet2) {
                                if (message.equals("CLOSE")) {
                                    socket.close();
                                    Log.log.info((Object)"App closed connection.", new Object[0]);
                                    break;
                                }
                                if (GetdownApplet.this._messageCallback != null) {
                                    GetdownApplet.this._messageCallback.call("call", GetdownApplet.this._messageCallback, message);
                                }
                            }
                        }
                    }
                    catch (IOException e) {
                        if (socket.isClosed()) break block11;
                        Log.log.warning((Object)"Error reading message.", new Object[]{e});
                    }
                }
                getdownApplet = GetdownApplet.this;
                synchronized (getdownApplet) {
                    GetdownApplet.this._connectOut = null;
                    return;
                }
            }
        };
        thread.setDaemon(true);
        thread.start();
    }

    public Image loadImage(String path) {
        try {
            return this.getImage(new URL(this.getDocumentBase(), path));
        }
        catch (MalformedURLException e) {
            Log.log.warning((Object)"Failed to load background image", new Object[]{"path", path, e});
            return null;
        }
    }

    public void start() {
        if (this._errmsg != null) {
            this._getdown.fail(this._errmsg);
        } else {
            try {
                this._getdown.start();
            }
            catch (Exception e) {
                Log.log.warning((Object)"start() failed.", new Object[]{e});
            }
        }
    }

    public void stop() {
        this._getdown.interrupt();
        this._getdown._app.releaseLock();
    }

    public synchronized void destroy() {
        if (this._serverSocket != null) {
            try {
                this._serverSocket.close();
            }
            catch (IOException e) {
                Log.log.warning((Object)"Error closing server socket.", new Object[]{e});
            }
        }
        if (this._connectOut != null) {
            try {
                this._connectOut.writeUTF("CLOSE");
                this._connectOut.close();
                Log.log.info((Object)"Disconnected from app.", new Object[0]);
            }
            catch (IOException e) {
                Log.log.warning((Object)"Error closing connect socket/output stream.", new Object[]{e});
            }
        }
    }

    protected boolean writeToFile(File tofile, String contents) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(tofile));
            out.println(contents);
            out.close();
            return true;
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Failed to create '" + tofile + "'."), new Object[]{ioe});
            return false;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static Certificate loadCertificate(String path) {
        Certificate certificate;
        URL keyUrl = GetdownApplet.class.getClassLoader().getResource(path);
        if (keyUrl == null) {
            return null;
        }
        InputStream is = keyUrl.openStream();
        try {
            certificate = CertificateFactory.getInstance("X.509").generateCertificate(is);
        }
        catch (Throwable throwable) {
            try {
                is.close();
                throw throwable;
            }
            catch (CertificateException e) {
                throw new RuntimeException(e);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        is.close();
        return certificate;
    }
}

