/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.launcher.Getdown;
import com.threerings.getdown.launcher.ImageLoader;
import com.threerings.getdown.launcher.RotatingBackgrounds;
import com.threerings.getdown.util.ConfigUtil;
import java.awt.Color;
import java.awt.Rectangle;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import javax.swing.JApplet;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class GetdownAppletConfig {
    public static final String APPBASE = "appbase";
    public static final String APPNAME = "appname";
    public static final String BGIMAGE = "bgimage";
    public static final String ERRORBGIMAGE = "errorbgimage";
    public static final String PARAM_DELIMITER = ".";
    public static final String DIRECT = "direct";
    public static final String CONNECT = "connect";
    public static final String REDIRECT_ON_FINISH = "redirect_on_finish";
    public static final String REDIRECT_ON_FINISH_TARGET = "redirect_on_finish_target";
    public static final String JVMARG_PREFIX = "jvmargs";
    public static final String APPARG_PREFIX = "appargs";
    public String appbase;
    public String appname;
    public String imgpath;
    public String errorimgpath;
    public File appdir;
    public String[] jvmargs;
    public String[] appargs;
    public URL redirectUrl;
    public String redirectTarget;
    public String installerFileContents;
    public boolean invokeDirect;
    public boolean allowConnect;
    public Rectangle statusBounds;
    public Color statusColor;
    protected JApplet _applet;
    protected String _prefix;
    protected RotatingBackgrounds bgimages;
    protected Properties _properties = new Properties();

    public GetdownAppletConfig(JApplet applet) {
        this(applet, null);
    }

    public GetdownAppletConfig(JApplet applet, String paramPrefix) {
        String root;
        this._applet = applet;
        this._prefix = paramPrefix;
        this.appbase = this.getParameter(APPBASE, "");
        this.appname = this.getParameter(APPNAME, "");
        Log.log.info((Object)("App Base: " + this.appbase), new Object[0]);
        Log.log.info((Object)("App Name: " + this.appname), new Object[0]);
        this.imgpath = this.getParameter(BGIMAGE);
        this.errorimgpath = this.getParameter(ERRORBGIMAGE);
        String props = this.getParameter("properties");
        if (props != null) {
            String[] proparray;
            for (String property : proparray = props.split(" ")) {
                String key = property.substring(property.indexOf("-D") + 2, property.indexOf("="));
                String value = property.substring(property.indexOf("=") + 1);
                this._properties.setProperty(key, value);
            }
        }
        if (RunAnywhere.isWindows()) {
            root = "Application Data";
            String verStr = System.getProperty("os.version");
            try {
                if (Float.parseFloat(verStr) >= 6.0f) {
                    root = "AppData" + File.separator + "LocalLow";
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)"Couldn't parse OS version", new Object[]{"vers", verStr, "error", e});
            }
        } else {
            root = RunAnywhere.isMacOS() ? "Library" + File.separator + "Application Support" : ".getdown";
        }
        this.appdir = new File(System.getProperty("user.home") + File.separator + root + File.separator + this.appname);
        this.installerFileContents = this.getParameter("installer");
        List<String> jvmalist = this.parseArgList(JVMARG_PREFIX);
        String appprops = this.getParameter("app_properties");
        if (appprops != null) {
            for (String jvmarg : appprops.split(",")) {
                jvmalist.add("-D" + jvmarg);
            }
        }
        this.jvmargs = jvmalist.toArray(new String[jvmalist.size()]);
        List<String> appalist = this.parseArgList(APPARG_PREFIX);
        this.appargs = appalist.toArray(new String[appalist.size()]);
        String direct = this.getParameter(DIRECT, "false");
        this.invokeDirect = Boolean.valueOf(direct);
        String connect = this.getParameter(CONNECT, "false");
        this.allowConnect = Boolean.valueOf(connect);
        String redirectURL = this.getParameter(REDIRECT_ON_FINISH);
        if (redirectURL != null) {
            try {
                this.redirectUrl = new URL(redirectURL);
                this.redirectTarget = this.getParameter(REDIRECT_ON_FINISH_TARGET);
            }
            catch (MalformedURLException e) {
                Log.log.warning((Object)("URL in redirect_on_finish param is malformed: " + e), new Object[0]);
            }
        }
        this.statusBounds = Application.parseRect("ui.status", this.getParameter("ui.status"));
        this.statusColor = Application.parseColor(this.getParameter("ui.status_text"));
    }

    public void init() throws Exception {
        this.securityCheck();
        this.setSystemProperties();
        this.ensureAppdirExists();
        this.createFiles();
        Log.log.info((Object)"------------------ VM Info ------------------", new Object[0]);
        Log.log.info((Object)("-- OS Name: " + System.getProperty("os.name")), new Object[0]);
        Log.log.info((Object)("-- OS Arch: " + System.getProperty("os.arch")), new Object[0]);
        Log.log.info((Object)("-- OS Vers: " + System.getProperty("os.version")), new Object[0]);
        Log.log.info((Object)("-- Java Vers: " + System.getProperty("java.version")), new Object[0]);
        Log.log.info((Object)("-- Java Home: " + System.getProperty("java.home")), new Object[0]);
        Log.log.info((Object)("-- User Name: " + System.getProperty("user.name")), new Object[0]);
        Log.log.info((Object)("-- User Home: " + System.getProperty("user.home")), new Object[0]);
        Log.log.info((Object)("-- Cur dir: " + System.getProperty("user.dir")), new Object[0]);
        Log.log.info((Object)"---------------------------------------------", new Object[0]);
    }

    public void config(Getdown getdown) {
        if (this.statusBounds != null) {
            getdown._ifc.status = this.statusBounds;
        }
        if (this.statusColor != null) {
            getdown._ifc.statusText = this.statusColor;
        }
    }

    public String getParameter(String param) {
        return this._prefix == null ? this._applet.getParameter(param) : this._applet.getParameter(this._prefix + PARAM_DELIMITER + param);
    }

    public String getParameter(String param, String defaultValue) {
        String value = this.getParameter(param);
        return value == null ? defaultValue : value;
    }

    public void redirect() {
        if (this.redirectUrl != null) {
            if (this.redirectTarget == null) {
                this._applet.getAppletContext().showDocument(this.redirectUrl);
            } else {
                this._applet.getAppletContext().showDocument(this.redirectUrl, this.redirectTarget);
            }
        }
    }

    public RotatingBackgrounds getBackgroundImages(ImageLoader loader) {
        if (this.bgimages == null) {
            this.bgimages = GetdownAppletConfig.getBackgroundImages(this.imgpath, this.errorimgpath, loader);
        }
        return this.bgimages;
    }

    public static RotatingBackgrounds getBackgroundImages(String imageParam, String errorImagePath, ImageLoader loader) {
        RotatingBackgrounds images = imageParam == null ? new RotatingBackgrounds() : (imageParam.indexOf(",") > -1 ? new RotatingBackgrounds(imageParam.split(","), errorImagePath, loader) : new RotatingBackgrounds(loader.loadImage(imageParam)));
        return images;
    }

    protected List<String> parseArgList(String prefix) {
        String value;
        ArrayList<String> arglist = new ArrayList<String>();
        int ii = 0;
        while ((value = this.getParameter(prefix + ii)) != null) {
            arglist.add(value);
            ++ii;
        }
        return arglist;
    }

    protected void securityCheck() throws Exception {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            try {
                sm.checkPropertiesAccess();
                sm.checkWrite("getdown");
            }
            catch (SecurityException se) {
                Log.log.warning((Object)"Signed applet rejected by user", new Object[]{"se", se});
                throw new Exception("m.insufficient_permissions_error");
            }
        }
    }

    protected void setSystemProperties() {
        System.getProperties().putAll((Map<?, ?>)this._properties);
    }

    protected void ensureAppdirExists() throws Exception {
        if (!(this.appdir.exists() && this.appdir.isDirectory() || this.appdir.mkdirs())) {
            throw new Exception("m.create_appdir_failed");
        }
    }

    protected void createFiles() throws Exception {
        File gdfile;
        boolean createGetdown;
        File infile;
        if (!StringUtil.isBlank((String)this.installerFileContents) && !(infile = new File(this.appdir, "installer.txt")).exists()) {
            this.writeToFile(infile, this.installerFileContents);
        }
        boolean bl = createGetdown = !(gdfile = new File(this.appdir, "getdown.txt")).exists();
        if (!createGetdown) {
            try {
                Map<String, Object> cdata = ConfigUtil.parseConfig(gdfile, false);
                String oappbase = StringUtil.trim((String)((String)cdata.get(APPBASE)));
                boolean bl2 = createGetdown = this.appbase != null && !this.appbase.trim().equals(oappbase);
                if (createGetdown) {
                    Log.log.warning((Object)"Recreating getdown.txt due to appbase mismatch", new Object[]{"nappbase", this.appbase, "oappbase", oappbase});
                }
            }
            catch (Exception e) {
                Log.log.warning((Object)"Failure checking validity of getdown.txt, forcing recreate.", new Object[]{"error", e});
                createGetdown = true;
            }
        }
        if (createGetdown) {
            if (StringUtil.isBlank((String)this.appbase)) {
                throw new Exception("m.missing_appbase");
            }
            if (!this.writeToFile(gdfile, "appbase = " + this.appbase)) {
                throw new Exception("m.create_getdown_failed");
            }
        }
    }

    protected boolean writeToFile(File tofile, String contents) {
        try {
            PrintStream out = new PrintStream(new FileOutputStream(tofile));
            out.println(contents);
            out.close();
            return true;
        }
        catch (IOException ioe) {
            Log.log.warning((Object)("Failed to create '" + tofile + "'."), new Object[]{ioe});
            return false;
        }
    }
}

