/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.launcher;

import com.samskivert.swing.GroupLayout;
import com.samskivert.swing.Spacer;
import com.samskivert.swing.VGroupLayout;
import com.samskivert.text.MessageUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.launcher.Getdown;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.LayoutManager;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ProxyPanel
extends JPanel
implements ActionListener {
    protected Getdown _getdown;
    protected ResourceBundle _msgs;
    protected JTextField _host;
    protected JTextField _port;

    public ProxyPanel(Getdown getdown, ResourceBundle msgs) {
        String port;
        this._getdown = getdown;
        this._msgs = msgs;
        this.setLayout((LayoutManager)new VGroupLayout());
        this.setBorder(BorderFactory.createEmptyBorder(10, 10, 10, 10));
        this.add(new JLabel(this.get("m.configure_proxy")));
        this.add((Component)new Spacer(5, 5));
        JPanel row = new JPanel(new BorderLayout(5, 5));
        row.add((Component)new JLabel(this.get("m.proxy_host")), "West");
        this._host = new SaneTextField();
        row.add(this._host);
        this.add(row);
        row = new JPanel(new BorderLayout(5, 5));
        row.add((Component)new JLabel(this.get("m.proxy_port")), "West");
        this._port = new SaneTextField();
        row.add(this._port);
        this.add(row);
        this.add((Component)new Spacer(5, 5));
        this.add(new JLabel(this.get("m.proxy_extra")));
        row = GroupLayout.makeButtonBox((GroupLayout.Justification)GroupLayout.CENTER, (Component[])new Component[0]);
        JButton button = new JButton(this.get("m.proxy_ok"));
        row.add(button);
        button.setActionCommand("ok");
        button.addActionListener(this);
        button = new JButton(this.get("m.proxy_cancel"));
        row.add(button);
        button.setActionCommand("cancel");
        button.addActionListener(this);
        this.add(row);
        String host = System.getProperty("http.proxyHost");
        if (host != null) {
            this._host.setText(host);
        }
        if ((port = System.getProperty("http.proxyPort")) != null) {
            this._port.setText(port);
        }
    }

    public void addNotify() {
        super.addNotify();
        this._host.requestFocusInWindow();
    }

    public Dimension getPreferredSize() {
        return new Dimension(500, 350);
    }

    public void actionPerformed(ActionEvent e) {
        String cmd = e.getActionCommand();
        if (cmd.equals("ok")) {
            this._getdown.configureProxy(this._host.getText(), this._port.getText());
        } else {
            System.exit(0);
        }
    }

    protected String get(String key) {
        if (MessageUtil.isTainted((String)key)) {
            return MessageUtil.untaint((String)key);
        }
        try {
            return this._msgs.getString(key);
        }
        catch (MissingResourceException mre) {
            Log.log.warning((Object)("Missing translation message '" + key + "'."), new Object[0]);
            return key;
        }
    }

    protected static class SaneTextField
    extends JTextField {
        protected SaneTextField() {
        }

        public Dimension getPreferredSize() {
            Dimension d = super.getPreferredSize();
            d.width = Math.max(d.width, 150);
            return d;
        }
    }
}

