/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.net;

import com.samskivert.io.StreamUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.net.Downloader;
import com.threerings.getdown.util.ConnectionUtil;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.HttpURLConnection;
import java.net.URLConnection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class HTTPDownloader
extends Downloader {
    public HTTPDownloader(List<Resource> resources, Downloader.Observer obs) {
        super(resources, obs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected long checkSize(Resource rsrc) throws IOException {
        URLConnection conn = ConnectionUtil.open(rsrc.getRemote());
        try {
            if (conn instanceof HttpURLConnection) {
                HttpURLConnection hcon = (HttpURLConnection)conn;
                hcon.setRequestMethod("HEAD");
                hcon.connect();
                if (hcon.getResponseCode() != 200) {
                    throw new IOException("Unable to check up-to-date for " + rsrc.getRemote() + ": " + hcon.getResponseCode());
                }
            }
            long l = conn.getContentLength();
            return l;
        }
        finally {
            conn.getInputStream().close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void doDownload(Resource rsrc) throws IOException {
        HttpURLConnection hcon;
        URLConnection conn = ConnectionUtil.open(rsrc.getRemote());
        conn.connect();
        if (conn instanceof HttpURLConnection && (hcon = (HttpURLConnection)conn).getResponseCode() != 200) {
            throw new IOException("Unable to download resource " + rsrc.getRemote() + ": " + hcon.getResponseCode());
        }
        long actualSize = conn.getContentLength();
        Log.log.info((Object)"Downloading resource", new Object[]{"url", rsrc.getRemote(), "size", actualSize});
        InputStream in = null;
        FileOutputStream out = null;
        long currentSize = 0L;
        try {
            int read;
            in = conn.getInputStream();
            out = new FileOutputStream(rsrc.getLocalNew());
            while ((read = in.read(this._buffer)) != -1) {
                out.write(this._buffer, 0, read);
                if (this._obs == null) continue;
                this.updateObserver(rsrc, currentSize += (long)read, actualSize);
            }
        }
        catch (Throwable throwable) {
            StreamUtil.close((InputStream)in);
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close((InputStream)in);
        StreamUtil.close((OutputStream)out);
    }
}

