/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import org.apache.commons.codec.binary.Base64;

public class AppletParamSigner {
    public static void main(String[] args) {
        try {
            if (args.length != 7) {
                System.err.println("AppletParamSigner keystore storepass alias keypass appbase appname imgpath");
                System.exit(255);
            }
            String keystore = args[0];
            String storepass = args[1];
            String alias = args[2];
            String keypass = args[3];
            String appbase = args[4];
            String appname = args[5];
            String imgpath = args[6];
            String params = appbase + appname + imgpath;
            KeyStore store = KeyStore.getInstance("JKS");
            store.load(new BufferedInputStream(new FileInputStream(keystore)), storepass.toCharArray());
            PrivateKey key = (PrivateKey)store.getKey(alias, keypass.toCharArray());
            Signature sig = Signature.getInstance("SHA1withRSA");
            sig.initSign(key);
            sig.update(params.getBytes());
            String signed = new String(Base64.encodeBase64((byte[])sig.sign()));
            System.out.println("<param name=\"appbase\" value=\"" + appbase + "\" />");
            System.out.println("<param name=\"appname\" value=\"" + appname + "\" />");
            System.out.println("<param name=\"bgimage\" value=\"" + imgpath + "\" />");
            System.out.println("<param name=\"signature\" value=\"" + signed + "\" />");
        }
        catch (Exception e) {
            System.err.println("Failed to produce signature.");
            e.printStackTrace();
        }
    }
}

