/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.samskivert.io.StreamUtil;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.Resource;
import com.threerings.getdown.tools.JarDiff;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.MessageDigest;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Differ {
    public void createDiff(File nvdir, File ovdir, boolean verbose) throws IOException {
        String nvers = nvdir.getName();
        String overs = ovdir.getName();
        try {
            if (Long.parseLong(nvers) <= Long.parseLong(overs)) {
                String err = "New version (" + nvers + ") must be greater " + "than old version (" + overs + ").";
                throw new IOException(err);
            }
        }
        catch (NumberFormatException nfe) {
            throw new IOException("Non-numeric versions? [nvers=" + nvers + ", overs=" + overs + "].");
        }
        Application oapp = new Application(ovdir, null);
        oapp.init(false);
        ArrayList<Resource> orsrcs = new ArrayList<Resource>();
        orsrcs.addAll(oapp.getCodeResources());
        orsrcs.addAll(oapp.getResources());
        Application napp = new Application(nvdir, null);
        napp.init(false);
        ArrayList<Resource> nrsrcs = new ArrayList<Resource>();
        nrsrcs.addAll(napp.getCodeResources());
        nrsrcs.addAll(napp.getResources());
        File patch = new File(nvdir, "patch" + overs + ".dat");
        this.createPatch(patch, orsrcs, nrsrcs, verbose);
        for (Application.AuxGroup ag : napp.getAuxGroups()) {
            orsrcs = new ArrayList();
            Application.AuxGroup oag = oapp.getAuxGroup(ag.name);
            if (oag != null) {
                orsrcs.addAll(oag.codes);
                orsrcs.addAll(oag.rsrcs);
            }
            nrsrcs = new ArrayList();
            nrsrcs.addAll(ag.codes);
            nrsrcs.addAll(ag.rsrcs);
            patch = new File(nvdir, "patch-" + ag.name + overs + ".dat");
            this.createPatch(patch, orsrcs, nrsrcs, verbose);
        }
    }

    protected void createPatch(File patch, ArrayList<Resource> orsrcs, ArrayList<Resource> nrsrcs, boolean verbose) throws IOException {
        MessageDigest md = Digest.getMessageDigest();
        JarOutputStream jout = null;
        try {
            jout = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(patch)));
            for (Resource rsrc : nrsrcs) {
                Resource orsrc;
                int oidx = orsrcs.indexOf(rsrc);
                Resource resource = orsrc = oidx == -1 ? null : orsrcs.remove(oidx);
                if (orsrc != null) {
                    String ndig;
                    String odig = orsrc.computeDigest(md, null);
                    if (odig.equals(ndig = rsrc.computeDigest(md, null))) {
                        if (!verbose) continue;
                        System.out.println("Unchanged: " + rsrc.getPath());
                        continue;
                    }
                    if (rsrc.getPath().endsWith(".jar")) {
                        if (verbose) {
                            System.out.println("JarDiff: " + rsrc.getPath());
                        }
                        File otemp = this.rebuildJar(orsrc.getLocal());
                        File temp = this.rebuildJar(rsrc.getLocal());
                        jout.putNextEntry(new ZipEntry(rsrc.getPath() + ".patch"));
                        this.jarDiff(otemp, temp, jout);
                        otemp.delete();
                        temp.delete();
                        continue;
                    }
                }
                if (verbose) {
                    System.out.println("Addition: " + rsrc.getPath());
                }
                jout.putNextEntry(new ZipEntry(rsrc.getPath() + ".create"));
                Differ.pipe(rsrc.getLocal(), jout);
            }
            for (Resource rsrc : orsrcs) {
                if (verbose) {
                    System.out.println("Removal: " + rsrc.getPath());
                }
                jout.putNextEntry(new ZipEntry(rsrc.getPath() + ".delete"));
            }
            StreamUtil.close((OutputStream)jout);
            System.out.println("Created patch file: " + patch);
        }
        catch (IOException ioe) {
            StreamUtil.close(jout);
            patch.delete();
            throw ioe;
        }
    }

    protected File rebuildJar(File target) throws IOException {
        JarFile jar = new JarFile(target);
        File temp = File.createTempFile("differ", "jar");
        JarOutputStream jout = new JarOutputStream(new BufferedOutputStream(new FileOutputStream(temp)));
        byte[] buffer = new byte[4096];
        Enumeration<JarEntry> iter = jar.entries();
        while (iter.hasMoreElements()) {
            JarEntry entry = iter.nextElement();
            entry.setCompressedSize(-1L);
            jout.putNextEntry(entry);
            InputStream in = jar.getInputStream(entry);
            int size = in.read(buffer);
            while (size != -1) {
                jout.write(buffer, 0, size);
                size = in.read(buffer);
            }
            in.close();
        }
        jout.close();
        jar.close();
        return temp;
    }

    protected void jarDiff(File ofile, File nfile, JarOutputStream jout) throws IOException {
        JarDiff.createPatch(ofile.getPath(), nfile.getPath(), jout, false);
    }

    public static void main(String[] args) {
        if (args.length < 2) {
            System.err.println("Usage: Differ [-verbose] new_vers_dir old_vers_dir");
            System.exit(255);
        }
        Differ differ = new Differ();
        boolean verbose = false;
        int aidx = 0;
        if (args[0].equals("-verbose")) {
            verbose = true;
            ++aidx;
        }
        try {
            differ.createDiff(new File(args[aidx++]), new File(args[aidx++]), verbose);
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.getMessage());
            System.exit(255);
        }
    }

    protected static void pipe(File file, JarOutputStream jout) throws IOException {
        FileInputStream fin = null;
        try {
            fin = new FileInputStream(file);
            StreamUtil.copy((InputStream)fin, (OutputStream)jout);
        }
        catch (Throwable throwable) {
            StreamUtil.close(fin);
            throw throwable;
        }
        StreamUtil.close((InputStream)fin);
    }
}

