/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.samskivert.io.StreamUtil;
import com.threerings.getdown.data.Application;
import com.threerings.getdown.data.Digest;
import com.threerings.getdown.data.Resource;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.Signature;
import java.util.ArrayList;
import org.apache.commons.codec.binary.Base64;

public class Digester {
    public static void main(String[] args) throws IOException, GeneralSecurityException {
        if (args.length != 1 && args.length != 4) {
            System.err.println("Usage: Digester app_dir [keystore_path password alias]");
            System.exit(255);
        }
        Digester.createDigest(new File(args[0]));
        if (args.length == 4) {
            Digester.signDigest(new File(args[0]), new File(args[1]), args[2], args[3]);
        }
    }

    public static void createDigest(File appdir) throws IOException {
        File target = new File(appdir, "digest.txt");
        System.out.println("Generating digest file '" + target + "'...");
        Application app = new Application(appdir, null);
        app.init(false);
        ArrayList<Resource> rsrcs = new ArrayList<Resource>();
        rsrcs.add(app.getConfigResource());
        rsrcs.addAll(app.getCodeResources());
        rsrcs.addAll(app.getResources());
        for (Application.AuxGroup ag : app.getAuxGroups()) {
            rsrcs.addAll(ag.codes);
            rsrcs.addAll(ag.rsrcs);
        }
        Digest.createDigest(rsrcs, target);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void signDigest(File appdir, File storePath, String storePass, String storeAlias) throws IOException, GeneralSecurityException {
        File inputFile = new File(appdir, "digest.txt");
        File signatureFile = new File(appdir, "digest.txt.sig");
        FileInputStream storeInput = null;
        FileInputStream dataInput = null;
        FileOutputStream signatureOutput = null;
        try {
            int length;
            KeyStore store = KeyStore.getInstance("JKS");
            storeInput = new FileInputStream(storePath);
            store.load(storeInput, storePass.toCharArray());
            PrivateKey key = (PrivateKey)store.getKey(storeAlias, storePass.toCharArray());
            Signature sig = Signature.getInstance("SHA1withRSA");
            dataInput = new FileInputStream(inputFile);
            byte[] buffer = new byte[8192];
            sig.initSign(key);
            while ((length = dataInput.read(buffer)) != -1) {
                sig.update(buffer, 0, length);
            }
            signatureOutput = new FileOutputStream(signatureFile);
            String signed = new String(Base64.encodeBase64((byte[])sig.sign()));
            signatureOutput.write(signed.getBytes("utf8"));
        }
        catch (Throwable throwable) {
            StreamUtil.close(signatureOutput);
            StreamUtil.close(dataInput);
            StreamUtil.close((InputStream)storeInput);
            throw throwable;
        }
        StreamUtil.close((OutputStream)signatureOutput);
        StreamUtil.close((InputStream)dataInput);
        StreamUtil.close((InputStream)storeInput);
    }
}

