/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.threerings.getdown.tools.JarDiffCodes;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarDiff
implements JarDiffCodes {
    private static final int DEFAULT_READ_SIZE = 2048;
    private static byte[] newBytes = new byte[2048];
    private static byte[] oldBytes = new byte[2048];
    private static boolean _debug;

    public static void createPatch(String oldPath, String newPath, OutputStream os, boolean minimal) throws IOException {
        JarFile2 oldJar = new JarFile2(oldPath);
        JarFile2 newJar = new JarFile2(newPath);
        try {
            HashMap<String, String> moved = new HashMap<String, String>();
            HashSet<String> implicit = new HashSet<String>();
            HashSet<String> moveSrc = new HashSet<String>();
            HashSet<String> newEntries = new HashSet<String>();
            for (Iterator newEntry : newJar) {
                String newname = ((ZipEntry)((Object)newEntry)).getName();
                String oldname = oldJar.getBestMatch(newJar, (JarEntry)((Object)newEntry));
                if (oldname == null) {
                    if (_debug) {
                        System.out.println("NEW: " + newname);
                    }
                    newEntries.add(newname);
                    continue;
                }
                if (oldname.equals(newname) && !moveSrc.contains(oldname)) {
                    if (_debug) {
                        System.out.println(newname + " added to implicit set!");
                    }
                    implicit.add(newname);
                    continue;
                }
                if (!minimal && (implicit.contains(oldname) || moveSrc.contains(oldname))) {
                    if (_debug) {
                        System.out.println("NEW: " + newname);
                    }
                    newEntries.add(newname);
                } else {
                    if (_debug) {
                        System.err.println("moved.put " + newname + " " + oldname);
                    }
                    moved.put(newname, oldname);
                    moveSrc.add(oldname);
                }
                if (!implicit.contains(oldname) || !minimal) continue;
                if (_debug) {
                    System.err.println("implicit.remove " + oldname);
                    System.err.println("moved.put " + oldname + " " + oldname);
                }
                implicit.remove(oldname);
                moved.put(oldname, oldname);
                moveSrc.add(oldname);
            }
            ArrayList<String> deleted = new ArrayList<String>();
            for (JarEntry oldEntry : oldJar) {
                String oldName = oldEntry.getName();
                if (implicit.contains(oldName) || moveSrc.contains(oldName) || newEntries.contains(oldName)) continue;
                if (_debug) {
                    System.err.println("deleted.add " + oldName);
                }
                deleted.add(oldName);
            }
            if (_debug) {
                System.out.println("MOVED MAP!!!");
                for (Map.Entry entry : moved.entrySet()) {
                    System.out.println(entry);
                }
                System.out.println("IMOVE MAP!!!");
                for (String newName : implicit) {
                    System.out.println("key is " + newName);
                }
            }
            JarOutputStream jos = new JarOutputStream(os);
            JarDiff.createIndex(jos, deleted, moved);
            for (String newName : newEntries) {
                if (_debug) {
                    System.out.println("New File: " + newName);
                }
                JarDiff.writeEntry(jos, newJar.getEntryByName(newName), newJar);
            }
            jos.finish();
        }
        catch (IOException ioE) {
            throw ioE;
        }
        finally {
            try {
                oldJar.getJarFile().close();
            }
            catch (IOException iOException) {}
            try {
                newJar.getJarFile().close();
            }
            catch (IOException iOException) {}
        }
    }

    private static void createIndex(JarOutputStream jos, List<String> oldEntries, Map<String, String> movedMap) throws IOException {
        StringWriter writer = new StringWriter();
        writer.write("version 1.0");
        writer.write("\r\n");
        for (String name : oldEntries) {
            writer.write("remove");
            writer.write(" ");
            JarDiff.writeEscapedString(writer, name);
            writer.write("\r\n");
        }
        for (String newName : movedMap.keySet()) {
            String oldName = movedMap.get(newName);
            writer.write("move");
            writer.write(" ");
            JarDiff.writeEscapedString(writer, oldName);
            writer.write(" ");
            JarDiff.writeEscapedString(writer, newName);
            writer.write("\r\n");
        }
        JarEntry je = new JarEntry("META-INF/INDEX.JD");
        byte[] bytes = writer.toString().getBytes("UTF-8");
        writer.close();
        jos.putNextEntry(je);
        jos.write(bytes, 0, bytes.length);
    }

    private static void writeEscapedString(Writer writer, String string) throws IOException {
        int index = 0;
        int last = 0;
        char[] chars = null;
        while ((index = string.indexOf(32, index)) != -1) {
            if (last != index) {
                if (chars == null) {
                    chars = string.toCharArray();
                }
                writer.write(chars, last, index - last);
            }
            last = index++;
            writer.write(92);
        }
        if (last != 0) {
            writer.write(chars, last, chars.length - last);
        } else {
            writer.write(string);
        }
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry, JarFile2 file) throws IOException {
        JarDiff.writeEntry(jos, entry, file.getJarFile().getInputStream(entry));
    }

    private static void writeEntry(JarOutputStream jos, JarEntry entry, InputStream data) throws IOException {
        jos.putNextEntry(entry);
        try {
            int size = data.read(newBytes);
            while (size != -1) {
                jos.write(newBytes, 0, size);
                size = data.read(newBytes);
            }
        }
        catch (IOException ioE) {
            throw ioE;
        }
        finally {
            try {
                data.close();
            }
            catch (IOException iOException) {}
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static class JarFile2
    implements Iterable<JarEntry> {
        private JarFile _jar;
        private List<JarEntry> _entries;
        private HashMap<String, JarEntry> _nameToEntryMap;
        private HashMap<Long, LinkedList<JarEntry>> _crcToEntryMap;

        public JarFile2(String path) throws IOException {
            this._jar = new JarFile(new File(path));
            this.index();
        }

        public JarFile getJarFile() {
            return this._jar;
        }

        @Override
        public Iterator<JarEntry> iterator() {
            return this._entries.iterator();
        }

        public JarEntry getEntryByName(String name) {
            return this._nameToEntryMap.get(name);
        }

        private static boolean differs(InputStream oldIS, InputStream newIS) throws IOException {
            int newSize = 0;
            int total = 0;
            boolean retVal = false;
            try {
                block13: while (newSize != -1) {
                    int oldSize;
                    newSize = newIS.read(newBytes);
                    if (newSize != (oldSize = oldIS.read(oldBytes))) {
                        if (_debug) {
                            System.out.println("\tread sizes differ: " + newSize + " " + oldSize + " total " + total);
                        }
                        retVal = true;
                        break;
                    }
                    if (newSize <= 0) continue;
                    while (--newSize >= 0) {
                        ++total;
                        if (newBytes[newSize] != oldBytes[newSize]) {
                            if (_debug) {
                                System.out.println("\tbytes differ at " + total);
                            }
                            retVal = true;
                            continue block13;
                        }
                        if (retVal) continue block13;
                        newSize = 0;
                    }
                }
            }
            catch (IOException ioE) {
                throw ioE;
            }
            finally {
                try {
                    oldIS.close();
                }
                catch (IOException iOException) {}
                try {
                    newIS.close();
                }
                catch (IOException iOException) {}
            }
            return retVal;
        }

        public String getBestMatch(JarFile2 file, JarEntry entry) throws IOException {
            if (this.contains(file, entry)) {
                return entry.getName();
            }
            return this.hasSameContent(file, entry);
        }

        public boolean contains(JarFile2 f, JarEntry e) throws IOException {
            InputStream newIS;
            JarEntry thisEntry = this.getEntryByName(e.getName());
            if (thisEntry == null) {
                return false;
            }
            if (thisEntry.getCrc() != e.getCrc()) {
                return false;
            }
            InputStream oldIS = this.getJarFile().getInputStream(thisEntry);
            boolean retValue = JarFile2.differs(oldIS, newIS = f.getJarFile().getInputStream(e));
            return !retValue;
        }

        public String hasSameContent(JarFile2 file, JarEntry entry) throws IOException {
            String thisName = null;
            Long crcL = new Long(entry.getCrc());
            if (this._crcToEntryMap.containsKey(crcL)) {
                LinkedList<JarEntry> ll = this._crcToEntryMap.get(crcL);
                ListIterator<JarEntry> li = ll.listIterator(0);
                while (li.hasNext()) {
                    InputStream newIS;
                    JarEntry thisEntry = li.next();
                    InputStream oldIS = this.getJarFile().getInputStream(thisEntry);
                    if (JarFile2.differs(oldIS, newIS = file.getJarFile().getInputStream(entry))) continue;
                    thisName = thisEntry.getName();
                    return thisName;
                }
            }
            return thisName;
        }

        private void index() throws IOException {
            Enumeration<JarEntry> entries = this._jar.entries();
            this._nameToEntryMap = new HashMap();
            this._crcToEntryMap = new HashMap();
            this._entries = new ArrayList<JarEntry>();
            if (_debug) {
                System.out.println("indexing: " + this._jar.getName());
            }
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    LinkedList<Object> ll;
                    JarEntry entry = entries.nextElement();
                    long crc = entry.getCrc();
                    Long crcL = new Long(crc);
                    if (_debug) {
                        System.out.println("\t" + entry.getName() + " CRC " + crc);
                    }
                    this._nameToEntryMap.put(entry.getName(), entry);
                    this._entries.add(entry);
                    if (this._crcToEntryMap.containsKey(crcL)) {
                        ll = this._crcToEntryMap.get(crcL);
                        ll.add(entry);
                        this._crcToEntryMap.put(crcL, ll);
                        continue;
                    }
                    ll = new LinkedList<JarEntry>();
                    ll.add(entry);
                    this._crcToEntryMap.put(crcL, ll);
                }
            }
        }
    }
}

