/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.samskivert.io.StreamUtil;
import com.threerings.getdown.tools.JarDiffCodes;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarOutputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class JarDiffPatcher
implements JarDiffCodes {
    protected static final int DEFAULT_READ_SIZE = 2048;
    protected static byte[] newBytes = new byte[2048];
    protected static byte[] oldBytes = new byte[2048];

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void patchJar(String jarPath, String diffPath, File target, ProgressObserver observer) throws IOException {
        File oldFile = new File(jarPath);
        File diffFile = new File(diffPath);
        JarOutputStream jos = null;
        JarFile oldJar = null;
        JarFile jarDiff = null;
        try {
            jos = new JarOutputStream(new FileOutputStream(target));
            oldJar = new JarFile(oldFile);
            jarDiff = new JarFile(diffFile);
            HashSet<String> ignoreSet = new HashSet<String>();
            HashMap<String, String> renameMap = new HashMap<String, String>();
            this.determineNameMapping(jarDiff, ignoreSet, renameMap);
            String[] keys = renameMap.keySet().toArray(new String[renameMap.size()]);
            HashSet<String> oldjarNames = new HashSet<String>();
            Enumeration<JarEntry> oldEntries = oldJar.entries();
            if (oldEntries != null) {
                while (oldEntries.hasMoreElements()) {
                    oldjarNames.add(oldEntries.nextElement().getName());
                }
            }
            double size = oldjarNames.size() + keys.length + jarDiff.size();
            double currentEntry = 0.0;
            oldjarNames.removeAll(ignoreSet);
            size -= (double)ignoreSet.size();
            Enumeration<JarEntry> entries = jarDiff.entries();
            if (entries != null) {
                while (entries.hasMoreElements()) {
                    JarEntry entry = entries.nextElement();
                    if (!"META-INF/INDEX.JD".equals(entry.getName())) {
                        this.updateObserver(observer, currentEntry, size);
                        currentEntry += 1.0;
                        this.writeEntry(jos, entry, jarDiff);
                        int wasInOld = oldjarNames.remove(entry.getName()) ? 1 : 0;
                        if (wasInOld == 0) continue;
                        size -= 1.0;
                        continue;
                    }
                    size -= 1.0;
                }
            }
            for (String newName : keys) {
                String oldName = (String)renameMap.get(newName);
                JarEntry oldEntry = oldJar.getJarEntry(oldName);
                if (oldEntry == null) {
                    String moveCmd = "move" + oldName + " " + (String)newName;
                    throw new IOException("error.badmove: " + moveCmd);
                }
                JarEntry newEntry = new JarEntry(newName);
                newEntry.setTime(oldEntry.getTime());
                newEntry.setSize(oldEntry.getSize());
                newEntry.setCompressedSize(oldEntry.getCompressedSize());
                newEntry.setCrc(oldEntry.getCrc());
                newEntry.setMethod(oldEntry.getMethod());
                newEntry.setExtra(oldEntry.getExtra());
                newEntry.setComment(oldEntry.getComment());
                this.updateObserver(observer, currentEntry, size);
                currentEntry += 1.0;
                this.writeEntry(jos, newEntry, oldJar.getInputStream(oldEntry));
                boolean wasInOld = oldjarNames.remove(oldName);
                if (!wasInOld) continue;
                size -= 1.0;
            }
            Iterator iEntries = oldjarNames.iterator();
            if (iEntries != null) {
                while (iEntries.hasNext()) {
                    String name = (String)iEntries.next();
                    JarEntry entry = oldJar.getJarEntry(name);
                    this.updateObserver(observer, currentEntry, size);
                    currentEntry += 1.0;
                    this.writeEntry(jos, entry, oldJar);
                }
            }
            this.updateObserver(observer, currentEntry, size);
        }
        catch (Throwable throwable) {
            StreamUtil.close(jos);
            JarDiffPatcher.closeFile(oldJar);
            JarDiffPatcher.closeFile(jarDiff);
            throw throwable;
        }
        StreamUtil.close((OutputStream)jos);
        JarDiffPatcher.closeFile(oldJar);
        JarDiffPatcher.closeFile(jarDiff);
    }

    protected void updateObserver(ProgressObserver observer, double currentSize, double size) {
        if (observer != null) {
            observer.progress((int)(100.0 * currentSize / size));
        }
    }

    protected void determineNameMapping(JarFile jarDiff, Set<String> ignoreSet, Map<String, String> renameMap) throws IOException {
        InputStream is = jarDiff.getInputStream(jarDiff.getEntry("META-INF/INDEX.JD"));
        if (is == null) {
            throw new IOException("error.noindex");
        }
        LineNumberReader indexReader = new LineNumberReader(new InputStreamReader(is, "UTF-8"));
        String line = indexReader.readLine();
        if (line == null || !line.equals("version 1.0")) {
            throw new IOException("jardiff.error.badheader: " + line);
        }
        while ((line = indexReader.readLine()) != null) {
            List<String> sub;
            if (line.startsWith("remove")) {
                sub = this.getSubpaths(line.substring("remove".length()));
                if (sub.size() != 1) {
                    throw new IOException("error.badremove: " + line);
                }
                ignoreSet.add(sub.get(0));
                continue;
            }
            if (line.startsWith("move")) {
                sub = this.getSubpaths(line.substring("move".length()));
                if (sub.size() != 2) {
                    throw new IOException("error.badmove: " + line);
                }
                if (renameMap.put(sub.get(1), sub.get(0)) == null) continue;
                throw new IOException("error.badmove: " + line);
            }
            if (line.length() <= 0) continue;
            throw new IOException("error.badcommand: " + line);
        }
    }

    protected List<String> getSubpaths(String path) {
        int index = 0;
        int length = path.length();
        ArrayList<String> sub = new ArrayList<String>();
        while (index < length) {
            int start;
            while (index < length && Character.isWhitespace(path.charAt(index))) {
                ++index;
            }
            if (index >= length) continue;
            int last = start = index;
            String subString = null;
            while (index < length) {
                char aChar = path.charAt(index);
                if (aChar == '\\' && index + 1 < length && path.charAt(index + 1) == ' ') {
                    subString = subString == null ? path.substring(last, index) : subString + path.substring(last, index);
                    last = ++index;
                } else if (Character.isWhitespace(aChar)) break;
                ++index;
            }
            if (last != index) {
                subString = subString == null ? path.substring(last, index) : subString + path.substring(last, index);
            }
            sub.add(subString);
        }
        return sub;
    }

    protected void writeEntry(JarOutputStream jos, JarEntry entry, JarFile file) throws IOException {
        this.writeEntry(jos, entry, file.getInputStream(entry));
    }

    protected void writeEntry(JarOutputStream jos, JarEntry entry, InputStream data) throws IOException {
        jos.putNextEntry(new JarEntry(entry.getName()));
        int size = data.read(newBytes);
        while (size != -1) {
            jos.write(newBytes, 0, size);
            size = data.read(newBytes);
        }
        data.close();
    }

    private static void closeFile(JarFile jar) {
        if (jar != null) {
            try {
                jar.close();
            }
            catch (IOException e) {
                e.printStackTrace(System.err);
            }
        }
    }
}

