/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.tools;

import com.samskivert.io.StreamUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.tools.JarDiffPatcher;
import com.threerings.getdown.util.FileUtil;
import com.threerings.getdown.util.ProgressObserver;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.zip.ZipEntry;

public class Patcher {
    public static final String CREATE = ".create";
    public static final String PATCH = ".patch";
    public static final String DELETE = ".delete";
    protected ProgressObserver _obs;
    protected long _complete;
    protected long _plength;
    protected byte[] _buffer;
    protected static final int COPY_BUFFER_SIZE = 4096;

    public void patch(File appdir, File patch, ProgressObserver obs) throws IOException {
        this._obs = obs;
        this._plength = patch.length();
        JarFile file = new JarFile(patch);
        Enumeration<JarEntry> entries = file.entries();
        while (entries.hasMoreElements()) {
            JarEntry entry = entries.nextElement();
            String path = entry.getName();
            long elength = entry.getCompressedSize();
            if (path.endsWith(CREATE)) {
                path = this.strip(path, CREATE);
                System.out.println("Creating " + path + "...");
                this.createFile(file, entry, new File(appdir, path));
            } else if (path.endsWith(PATCH)) {
                path = this.strip(path, PATCH);
                System.out.println("Patching " + path + "...");
                this.patchFile(file, entry, appdir, path);
            } else if (path.endsWith(DELETE)) {
                path = this.strip(path, DELETE);
                System.out.println("Removing " + path + "...");
                File target = new File(appdir, path);
                if (!target.delete()) {
                    System.err.println("Failure deleting '" + target + "'.");
                }
            } else {
                System.err.println("Skipping bogus patch file entry: " + path);
            }
            this._complete += elength;
        }
        file.close();
    }

    protected String strip(String path, String suffix) {
        return path.substring(0, path.length() - suffix.length());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void createFile(JarFile file, ZipEntry entry, File target) {
        File pdir;
        if (this._buffer == null) {
            this._buffer = new byte[4096];
        }
        if (!(pdir = target.getParentFile()).exists() && !pdir.mkdirs()) {
            Log.log.warning((Object)("Failed to create parent for '" + target + "'."), new Object[0]);
        }
        InputStream in = null;
        FileOutputStream fout = null;
        try {
            int read;
            in = file.getInputStream(entry);
            fout = new FileOutputStream(target);
            int total = 0;
            while ((read = in.read(this._buffer)) != -1) {
                fout.write(this._buffer, 0, read);
                this.updateProgress(total += read);
            }
        }
        catch (IOException ioe) {
            try {
                System.err.println("Error creating '" + target + "': " + ioe);
            }
            catch (Throwable throwable) {
                StreamUtil.close((InputStream)in);
                StreamUtil.close(fout);
                throw throwable;
            }
            StreamUtil.close((InputStream)in);
            StreamUtil.close((OutputStream)fout);
        }
        StreamUtil.close((InputStream)in);
        StreamUtil.close((OutputStream)fout);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected void patchFile(JarFile file, ZipEntry entry, File appdir, String path) {
        FileOutputStream fout;
        InputStream in;
        JarDiffPatcher patcher;
        File otarget;
        File patch;
        File target;
        block10: {
            target = new File(appdir, path);
            patch = new File(appdir, entry.getName());
            otarget = new File(appdir, path + ".old");
            patcher = null;
            otarget.delete();
            in = null;
            fout = null;
            in = file.getInputStream(entry);
            fout = new FileOutputStream(patch);
            StreamUtil.copy((InputStream)in, (OutputStream)fout);
            StreamUtil.close((OutputStream)fout);
            fout = null;
            if (FileUtil.renameTo(target, otarget)) break block10;
            System.err.println("Failed to .oldify '" + target + "'.");
            StreamUtil.close((OutputStream)fout);
            StreamUtil.close((InputStream)in);
            if (!patch.delete()) {
                patch.deleteOnExit();
            }
            if (otarget.delete()) return;
            otarget.deleteOnExit();
            return;
        }
        try {
            final long elength = entry.getCompressedSize();
            ProgressObserver obs = new ProgressObserver(){

                public void progress(int percent) {
                    Patcher.this.updateProgress((int)((long)percent * elength / 100L));
                }
            };
            patcher = new JarDiffPatcher();
            patcher.patchJar(otarget.getPath(), patch.getPath(), target, obs);
        }
        catch (IOException ioe) {
            block11: {
                try {
                    if (patcher == null) {
                        System.err.println("Failed to write patch file '" + patch + "': " + ioe);
                        break block11;
                    }
                    System.err.println("Error patching '" + target + "': " + ioe);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(fout);
                    StreamUtil.close((InputStream)in);
                    if (!patch.delete()) {
                        patch.deleteOnExit();
                    }
                    if (otarget.delete()) throw throwable;
                    otarget.deleteOnExit();
                    throw throwable;
                }
            }
            StreamUtil.close((OutputStream)fout);
            StreamUtil.close((InputStream)in);
            if (!patch.delete()) {
                patch.deleteOnExit();
            }
            if (otarget.delete()) return;
            otarget.deleteOnExit();
            return;
        }
        StreamUtil.close((OutputStream)fout);
        StreamUtil.close((InputStream)in);
        if (!patch.delete()) {
            patch.deleteOnExit();
        }
        if (otarget.delete()) return;
        otarget.deleteOnExit();
        return;
    }

    protected void updateProgress(int progress) {
        if (this._obs != null) {
            this._obs.progress((int)(100L * (this._complete + (long)progress) / this._plength));
        }
    }

    public static void main(String[] args) {
        if (args.length != 2) {
            System.err.println("Usage: Patcher appdir patch_file");
            System.exit(-1);
        }
        Patcher patcher = new Patcher();
        try {
            patcher.patch(new File(args[0]), new File(args[1]), null);
        }
        catch (IOException ioe) {
            System.err.println("Error: " + ioe.getMessage());
            System.exit(-1);
        }
    }
}

