/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ConfigUtil {
    public static List<String[]> parsePairs(File config, boolean checkPlatform) throws IOException {
        return ConfigUtil.parsePairs(new InputStreamReader((InputStream)new FileInputStream(config), "UTF-8"), checkPlatform);
    }

    public static List<String[]> parsePairs(Reader config, boolean checkPlatform) throws IOException {
        return ConfigUtil.parsePairs(config, checkPlatform ? StringUtil.deNull((String)System.getProperty("os.name")).toLowerCase() : null, checkPlatform ? StringUtil.deNull((String)System.getProperty("os.arch")).toLowerCase() : null);
    }

    public static Map<String, Object> parseConfig(File config, boolean checkPlatform) throws IOException {
        HashMap<String, Object> data = new HashMap<String, Object>();
        for (String[] pair : ConfigUtil.parsePairs(config, checkPlatform)) {
            Object value = data.get(pair[0]);
            if (value == null) {
                data.put(pair[0], pair[1]);
                continue;
            }
            if (value instanceof String) {
                data.put(pair[0], new String[]{(String)value, pair[1]});
                continue;
            }
            if (!(value instanceof String[])) continue;
            String[] values = (String[])value;
            String[] nvalues = new String[values.length + 1];
            System.arraycopy(values, 0, nvalues, 0, values.length);
            nvalues[values.length] = pair[1];
            data.put(pair[0], nvalues);
        }
        return data;
    }

    public static String[] getMultiValue(Map<String, Object> data, String name) {
        Object value = data.get(name);
        if (value instanceof String) {
            return new String[]{(String)value};
        }
        return (String[])value;
    }

    protected static List<String[]> parsePairs(Reader config, String osname, String osarch) throws IOException {
        ArrayList<String[]> pairs = new ArrayList<String[]>();
        for (String line : FileUtil.readLines(config)) {
            int cidx = line.indexOf("#");
            if (cidx != -1) {
                line = line.substring(0, cidx);
            }
            if (StringUtil.isBlank((String)(line = line.trim()))) continue;
            String[] pair = new String[2];
            int eidx = line.indexOf("=");
            if (eidx != -1) {
                pair[0] = line.substring(0, eidx).trim();
                pair[1] = line.substring(eidx + 1).trim();
            } else {
                pair[0] = line;
                pair[1] = "";
            }
            if (pair[1].startsWith("[")) {
                int qidx = pair[1].indexOf("]");
                if (qidx == -1) {
                    Log.log.warning((Object)"Bogus platform specifier", new Object[]{"key", pair[0], "value", pair[1]});
                    continue;
                }
                String quals = pair[1].substring(1, qidx);
                if (osname != null && !ConfigUtil.checkQualifiers(quals, osname, osarch)) {
                    Log.log.debug((Object)"Skipping", new Object[]{"quals", quals, "osname", osname, "osarch", osarch, "key", pair[0], "value", pair[1]});
                    continue;
                }
                pair[1] = pair[1].substring(qidx + 1).trim();
            }
            pairs.add(pair);
        }
        return pairs;
    }

    protected static boolean checkQualifiers(String quals, String osname, String osarch) {
        if (quals.startsWith("!")) {
            if (quals.indexOf(",") != -1) {
                Log.log.warning((Object)"Multiple qualifiers cannot be used when one of the qualifiers is negative", new Object[]{"quals", quals});
                return false;
            }
            return !ConfigUtil.checkQualifier(quals.substring(1), osname, osarch);
        }
        for (String qual : quals.split(",")) {
            if (!ConfigUtil.checkQualifier(qual, osname, osarch)) continue;
            return true;
        }
        return false;
    }

    protected static boolean checkQualifier(String qual, String osname, String osarch) {
        String[] bits = qual.trim().toLowerCase().split("-");
        String os = bits[0];
        String arch = bits.length > 1 ? bits[1] : "";
        return osname.indexOf(os) != -1 && osarch.indexOf(arch) != -1;
    }
}

