/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.samskivert.io.StreamUtil;
import com.threerings.getdown.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.jar.JarOutputStream;
import java.util.jar.Pack200;
import java.util.zip.GZIPInputStream;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileUtil
extends com.samskivert.util.FileUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean renameTo(File source, File dest) {
        boolean bl;
        if (source.renameTo(dest)) {
            return true;
        }
        if (dest.exists()) {
            File temp = new File(dest.getPath() + "_old");
            if (temp.exists() && !temp.delete()) {
                Log.log.warning((Object)("Failed to delete old intermediate file " + temp + "."), new Object[0]);
            }
            if (dest.renameTo(temp) && source.renameTo(dest)) {
                if (!temp.delete()) {
                    Log.log.warning((Object)("Failed to delete intermediate file " + temp + "."), new Object[0]);
                }
                return true;
            }
        }
        FileInputStream fin = null;
        FileOutputStream fout = null;
        try {
            fin = new FileInputStream(source);
            fout = new FileOutputStream(dest);
            StreamUtil.copy((InputStream)fin, (OutputStream)fout);
            fin.close();
            if (!source.delete()) {
                Log.log.warning((Object)("Failed to delete " + source + " after brute force copy to " + dest + "."), new Object[0]);
            }
            bl = true;
        }
        catch (IOException ioe) {
            boolean bl2;
            try {
                Log.log.warning((Object)("Failed to copy " + source + " to " + dest + ": " + ioe), new Object[0]);
                bl2 = false;
            }
            catch (Throwable throwable) {
                StreamUtil.close(fin);
                StreamUtil.close(fout);
                throw throwable;
            }
            StreamUtil.close((InputStream)fin);
            StreamUtil.close((OutputStream)fout);
            return bl2;
        }
        StreamUtil.close((InputStream)fin);
        StreamUtil.close((OutputStream)fout);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<String> readLines(Reader in) throws IOException {
        ArrayList<String> lines = new ArrayList<String>();
        try {
            BufferedReader bin = new BufferedReader(in);
            String line = null;
            while ((line = bin.readLine()) != null) {
                lines.add(line);
            }
        }
        finally {
            StreamUtil.close((Reader)in);
        }
        return lines;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean unpackPacked200Jar(File packedJar, File target) {
        boolean bl;
        InputStream packedJarIn = null;
        FileOutputStream extractedJarFileOut = null;
        JarOutputStream jarOutputStream = null;
        try {
            extractedJarFileOut = new FileOutputStream(target);
            jarOutputStream = new JarOutputStream(extractedJarFileOut);
            packedJarIn = new FileInputStream(packedJar);
            if (packedJar.getName().endsWith(".gz")) {
                packedJarIn = new GZIPInputStream(packedJarIn);
            }
            Pack200.Unpacker unpacker = Pack200.newUnpacker();
            unpacker.unpack(packedJarIn, jarOutputStream);
            bl = true;
        }
        catch (IOException e) {
            boolean bl2;
            try {
                Log.log.warning((Object)"Failed to unpack packed 200 jar file", new Object[]{"jar", packedJar, "error", e});
                bl2 = false;
            }
            catch (Throwable throwable) {
                StreamUtil.close(jarOutputStream);
                StreamUtil.close((OutputStream)extractedJarFileOut);
                StreamUtil.close(packedJarIn);
                throw throwable;
            }
            StreamUtil.close((OutputStream)jarOutputStream);
            StreamUtil.close((OutputStream)extractedJarFileOut);
            StreamUtil.close((InputStream)packedJarIn);
            return bl2;
        }
        StreamUtil.close((OutputStream)jarOutputStream);
        StreamUtil.close((OutputStream)extractedJarFileOut);
        StreamUtil.close((InputStream)packedJarIn);
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void copy(File source, File target) throws IOException {
        FileInputStream in = null;
        FileOutputStream out = null;
        try {
            in = new FileInputStream(source);
            out = new FileOutputStream(target);
            StreamUtil.copy((InputStream)in, (OutputStream)out);
        }
        catch (Throwable throwable) {
            StreamUtil.close(in);
            StreamUtil.close(out);
            throw throwable;
        }
        StreamUtil.close((InputStream)in);
        StreamUtil.close((OutputStream)out);
    }

    public static void walkTree(File root, Visitor visitor) {
        ArrayDeque<File> stack = new ArrayDeque<File>(Arrays.asList(root.listFiles()));
        while (!stack.isEmpty()) {
            File currentFile = (File)stack.pop();
            if (!currentFile.exists()) continue;
            visitor.visit(currentFile);
            if (!currentFile.isDirectory()) continue;
            for (File file : currentFile.listFiles()) {
                stack.push(file);
            }
        }
    }

    public static interface Visitor {
        public void visit(File var1);
    }
}

