/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.samskivert.util.RunAnywhere;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import com.threerings.getdown.util.FileUtil;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintStream;

public class LaunchUtil {
    public static final String LOCAL_JAVA_DIR = "java_vm";

    public static boolean updateVersionAndRelaunch(File appdir, String getdownJarName, String newVersion) throws IOException {
        File vfile = new File(appdir, "version.txt");
        PrintStream ps = new PrintStream(new FileOutputStream(vfile));
        ps.println(newVersion);
        ps.close();
        File pro = new File(appdir, getdownJarName);
        if (LaunchUtil.mustMonitorChildren() || !pro.exists()) {
            return false;
        }
        Object[] args = new String[]{LaunchUtil.getJVMPath(appdir), "-jar", pro.toString(), appdir.getPath()};
        Log.log.info((Object)("Running " + StringUtil.join((Object[])args, (String)"\n  ")), new Object[0]);
        try {
            Runtime.getRuntime().exec((String[])args, null);
            return true;
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Failed to run getdown", new Object[]{ioe});
            return false;
        }
    }

    public static String getJVMPath(File appdir) {
        return LaunchUtil.getJVMPath(appdir, false);
    }

    public static String getJVMPath(File appdir, boolean windebug) {
        String vmpath = LaunchUtil.checkJVMPath(new File(appdir, LOCAL_JAVA_DIR).getPath(), windebug);
        if (vmpath == null) {
            vmpath = LaunchUtil.checkJVMPath(System.getProperty("java.home"), windebug);
        }
        if (vmpath == null) {
            Log.log.warning((Object)("Unable to find java [appdir=" + appdir + ", java.home=" + System.getProperty("java.home") + "]!"), new Object[0]);
            vmpath = "java";
        }
        if (RunAnywhere.isMacOS()) {
            try {
                File localVM = new File("/usr/bin/java").getCanonicalFile();
                if (localVM.equals(new File(vmpath).getCanonicalFile())) {
                    vmpath = "/usr/bin/java";
                }
            }
            catch (IOException ioe) {
                Log.log.warning((Object)"Failed to check Mac OS canonical VM path.", new Object[]{ioe});
            }
        }
        return vmpath;
    }

    public static void upgradeGetdown(File oldgd, File curgd, File newgd) {
        if (!newgd.exists() || newgd.length() == curgd.length()) {
            return;
        }
        Log.log.info((Object)("Updating Getdown with " + newgd + "..."), new Object[0]);
        if (oldgd.exists()) {
            oldgd.delete();
        }
        if (!curgd.exists() || curgd.renameTo(oldgd)) {
            if (newgd.renameTo(curgd)) {
                oldgd.delete();
                try {
                    FileUtil.copy(curgd, newgd);
                }
                catch (IOException e) {
                    Log.log.warning((Object)("Error copying updated Getdown back: " + e), new Object[0]);
                }
                return;
            }
            Log.log.warning((Object)("Unable to renameTo(" + oldgd + ")."), new Object[0]);
            if (!oldgd.renameTo(curgd)) {
                Log.log.warning((Object)"Oh God, why dost thee scorn me so.", new Object[0]);
            }
        }
        Log.log.info((Object)("Attempting to upgrade by copying over " + curgd + "..."), new Object[0]);
        try {
            FileUtil.copy(newgd, curgd);
        }
        catch (IOException ioe) {
            Log.log.warning((Object)"Mayday! Brute force copy method also failed.", new Object[]{ioe});
        }
    }

    public static boolean mustMonitorChildren() {
        String osname = System.getProperty("os.name").toLowerCase();
        return osname.indexOf("windows 98") != -1 || osname.indexOf("windows me") != -1;
    }

    protected static String checkJVMPath(String vmhome, boolean windebug) {
        String vmbase = vmhome + File.separator + "bin" + File.separator;
        String vmpath = vmbase + "java";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        if (!windebug && new File(vmpath = vmbase + "javaw.exe").exists()) {
            return vmpath;
        }
        vmpath = vmbase + "java.exe";
        if (new File(vmpath).exists()) {
            return vmpath;
        }
        return null;
    }
}

