/*
 * Decompiled with CFR 0.152.
 */
package com.threerings.getdown.util;

import com.samskivert.io.StreamUtil;
import com.samskivert.util.StringUtil;
import com.threerings.getdown.Log;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Reader;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class VersionUtil {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readVersion(File vfile) {
        BufferedReader bin;
        long fileVersion;
        block4: {
            fileVersion = -1L;
            bin = null;
            try {
                bin = new BufferedReader(new InputStreamReader(new FileInputStream(vfile)));
                String vstr = bin.readLine();
                if (StringUtil.isBlank((String)vstr)) break block4;
                fileVersion = Long.parseLong(vstr);
            }
            catch (Exception e) {
                try {
                    Log.log.info((Object)("Unable to read version file: " + e.getMessage()), new Object[0]);
                }
                catch (Throwable throwable) {
                    StreamUtil.close(bin);
                    throw throwable;
                }
                StreamUtil.close((Reader)bin);
            }
        }
        StreamUtil.close((Reader)bin);
        return fileVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeVersion(File vfile, long version) throws IOException {
        PrintStream out = new PrintStream(new FileOutputStream(vfile));
        try {
            out.println(version);
        }
        catch (Exception e) {
            Log.log.warning((Object)("Unable to write version file: " + e.getMessage()), new Object[0]);
        }
        finally {
            StreamUtil.close((OutputStream)out);
        }
    }

    public static long parseJavaVersion(String versRegex, String versStr) {
        Matcher m = Pattern.compile(versRegex).matcher(versStr);
        if (!m.matches()) {
            return 0L;
        }
        long vers = 0L;
        for (int ii = 1; ii <= m.groupCount(); ++ii) {
            String valstr = m.group(ii);
            int value = valstr == null ? 0 : VersionUtil.parseInt(valstr);
            vers *= 100L;
            vers += (long)value;
        }
        return vers;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long readReleaseVersion(File relfile, String versRegex) {
        long l;
        String relvers;
        BufferedReader in;
        block6: {
            in = null;
            in = new BufferedReader(new FileReader(relfile));
            String line = null;
            relvers = null;
            while ((line = in.readLine()) != null) {
                if (!line.startsWith("JAVA_VERSION=")) continue;
                relvers = line.substring("JAVA_VERSION=".length()).replace('\"', ' ').trim();
            }
            if (relvers != null) break block6;
            Log.log.warning((Object)"No JAVA_VERSION line in 'release' file", new Object[]{"file", relfile});
            long l2 = 0L;
            StreamUtil.close((Reader)in);
            return l2;
        }
        try {
            l = VersionUtil.parseJavaVersion(versRegex, relvers);
        }
        catch (Exception e) {
            long l3;
            try {
                Log.log.warning((Object)"Failed to read version from 'release' file", new Object[]{"file", relfile, e});
                l3 = 0L;
            }
            catch (Throwable throwable) {
                StreamUtil.close(in);
                throw throwable;
            }
            StreamUtil.close((Reader)in);
            return l3;
        }
        StreamUtil.close((Reader)in);
        return l;
    }

    private static int parseInt(String str) {
        int value = 0;
        int ll = str.length();
        for (int ii = 0; ii < ll; ++ii) {
            char c = str.charAt(ii);
            if (c < '0' || c > '9') continue;
            value *= 10;
            value += c - 48;
        }
        return value;
    }
}

